<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerBranch StructType
 * @subpackage Structs
 */
class UpdateCustomerBranch extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The destinationBranchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $destinationBranchId;
    /**
     * Constructor method for UpdateCustomerBranch
     * @uses UpdateCustomerBranch::setCustomerId()
     * @uses UpdateCustomerBranch::setDestinationBranchId()
     * @param int $customerId
     * @param int $destinationBranchId
     */
    public function __construct($customerId = null, $destinationBranchId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDestinationBranchId($destinationBranchId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerBranch
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get destinationBranchId value
     * @return int
     */
    public function getDestinationBranchId()
    {
        return $this->destinationBranchId;
    }
    /**
     * Set destinationBranchId value
     * @param int $destinationBranchId
     * @return \CustomerManagement\StructType\UpdateCustomerBranch
     */
    public function setDestinationBranchId($destinationBranchId = null)
    {
        // validation for constraint: int
        if (!is_null($destinationBranchId) && !is_numeric($destinationBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationBranchId)), __LINE__);
        }
        $this->destinationBranchId = $destinationBranchId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCustomerBranch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
