<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAuthenticationProviderLoginName StructType
 * @subpackage Structs
 */
class UpdateAuthenticationProviderLoginName extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The oldLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $oldLogin;
    /**
     * The newLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $newLogin;
    /**
     * Constructor method for UpdateAuthenticationProviderLoginName
     * @uses UpdateAuthenticationProviderLoginName::setCustomerId()
     * @uses UpdateAuthenticationProviderLoginName::setOldLogin()
     * @uses UpdateAuthenticationProviderLoginName::setNewLogin()
     * @param int $customerId
     * @param string $oldLogin
     * @param string $newLogin
     */
    public function __construct($customerId = null, $oldLogin = null, $newLogin = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setOldLogin($oldLogin)
            ->setNewLogin($newLogin);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateAuthenticationProviderLoginName
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get oldLogin value
     * @return string|null
     */
    public function getOldLogin()
    {
        return $this->oldLogin;
    }
    /**
     * Set oldLogin value
     * @param string $oldLogin
     * @return \CustomerManagement\StructType\UpdateAuthenticationProviderLoginName
     */
    public function setOldLogin($oldLogin = null)
    {
        // validation for constraint: string
        if (!is_null($oldLogin) && !is_string($oldLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldLogin)), __LINE__);
        }
        $this->oldLogin = $oldLogin;
        return $this;
    }
    /**
     * Get newLogin value
     * @return string|null
     */
    public function getNewLogin()
    {
        return $this->newLogin;
    }
    /**
     * Set newLogin value
     * @param string $newLogin
     * @return \CustomerManagement\StructType\UpdateAuthenticationProviderLoginName
     */
    public function setNewLogin($newLogin = null)
    {
        // validation for constraint: string
        if (!is_null($newLogin) && !is_string($newLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newLogin)), __LINE__);
        }
        $this->newLogin = $newLogin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateAuthenticationProviderLoginName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
