<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendEnterpriseNotice StructType
 * @subpackage Structs
 */
class SendEnterpriseNotice extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The messageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $messageId;
    /**
     * The messageParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfString
     */
    public $messageParameters;
    /**
     * Constructor method for SendEnterpriseNotice
     * @uses SendEnterpriseNotice::setCustomerId()
     * @uses SendEnterpriseNotice::setMessageId()
     * @uses SendEnterpriseNotice::setMessageParameters()
     * @param int $customerId
     * @param int $messageId
     * @param \CustomerManagement\ArrayType\ArrayOfString $messageParameters
     */
    public function __construct($customerId = null, $messageId = null, \CustomerManagement\ArrayType\ArrayOfString $messageParameters = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setMessageId($messageId)
            ->setMessageParameters($messageParameters);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SendEnterpriseNotice
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get messageId value
     * @return int
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param int $messageId
     * @return \CustomerManagement\StructType\SendEnterpriseNotice
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: int
        if (!is_null($messageId) && !is_numeric($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get messageParameters value
     * @return \CustomerManagement\ArrayType\ArrayOfString|null
     */
    public function getMessageParameters()
    {
        return $this->messageParameters;
    }
    /**
     * Set messageParameters value
     * @param \CustomerManagement\ArrayType\ArrayOfString $messageParameters
     * @return \CustomerManagement\StructType\SendEnterpriseNotice
     */
    public function setMessageParameters(\CustomerManagement\ArrayType\ArrayOfString $messageParameters = null)
    {
        $this->messageParameters = $messageParameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SendEnterpriseNotice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
