<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Email ServiceType
 * @subpackage Services
 */
class Email extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named EmailWelcomeLetter
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Email a welcome letter to the customer matching the provided ID. | Email a welcome letter to the customer matching the provided ID. | Email a welcome letter to the customer matching the provided ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\EmailWelcomeLetter $parameters
     * @return \CustomerManagement\StructType\EmailWelcomeLetterResponse|bool
     */
    public function EmailWelcomeLetter(\CustomerManagement\StructType\EmailWelcomeLetter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EmailWelcomeLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\EmailWelcomeLetterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
