<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSensorDeviceInput StructType
 * @subpackage Structs
 */
class UpdateSensorDeviceInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SensorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorId;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupId;
    /**
     * The SensorNamePrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNamePrefix;
    /**
     * The SensorNameBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNameBase;
    /**
     * The SensorNameSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNameSuffix;
    /**
     * The SensorNameToken3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNameToken3;
    /**
     * The SensorNameToken4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorNameToken4;
    /**
     * The SensorTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorTypeId;
    /**
     * The SensorName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorName;
    /**
     * The DLCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DLCode;
    /**
     * Constructor method for UpdateSensorDeviceInput
     * @uses UpdateSensorDeviceInput::setCustomerId()
     * @uses UpdateSensorDeviceInput::setSensorId()
     * @uses UpdateSensorDeviceInput::setGroupId()
     * @uses UpdateSensorDeviceInput::setSensorNamePrefix()
     * @uses UpdateSensorDeviceInput::setSensorNameBase()
     * @uses UpdateSensorDeviceInput::setSensorNameSuffix()
     * @uses UpdateSensorDeviceInput::setSensorNameToken3()
     * @uses UpdateSensorDeviceInput::setSensorNameToken4()
     * @uses UpdateSensorDeviceInput::setSensorTypeId()
     * @uses UpdateSensorDeviceInput::setSensorName()
     * @uses UpdateSensorDeviceInput::setDLCode()
     * @param int $customerId
     * @param int $sensorId
     * @param int $groupId
     * @param string $sensorNamePrefix
     * @param string $sensorNameBase
     * @param string $sensorNameSuffix
     * @param string $sensorNameToken3
     * @param string $sensorNameToken4
     * @param string $sensorTypeId
     * @param string $sensorName
     * @param string $dLCode
     */
    public function __construct($customerId = null, $sensorId = null, $groupId = null, $sensorNamePrefix = null, $sensorNameBase = null, $sensorNameSuffix = null, $sensorNameToken3 = null, $sensorNameToken4 = null, $sensorTypeId = null, $sensorName = null, $dLCode = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSensorId($sensorId)
            ->setGroupId($groupId)
            ->setSensorNamePrefix($sensorNamePrefix)
            ->setSensorNameBase($sensorNameBase)
            ->setSensorNameSuffix($sensorNameSuffix)
            ->setSensorNameToken3($sensorNameToken3)
            ->setSensorNameToken4($sensorNameToken4)
            ->setSensorTypeId($sensorTypeId)
            ->setSensorName($sensorName)
            ->setDLCode($dLCode);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SensorId value
     * @return int
     */
    public function getSensorId()
    {
        return $this->SensorId;
    }
    /**
     * Set SensorId value
     * @param int $sensorId
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setSensorId($sensorId = null)
    {
        // validation for constraint: int
        if (!is_null($sensorId) && !is_numeric($sensorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sensorId)), __LINE__);
        }
        $this->SensorId = $sensorId;
        return $this;
    }
    /**
     * Get GroupId value
     * @return int
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !is_numeric($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get SensorNamePrefix value
     * @return string|null
     */
    public function getSensorNamePrefix()
    {
        return $this->SensorNamePrefix;
    }
    /**
     * Set SensorNamePrefix value
     * @param string $sensorNamePrefix
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setSensorNamePrefix($sensorNamePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNamePrefix) && !is_string($sensorNamePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorNamePrefix)), __LINE__);
        }
        $this->SensorNamePrefix = $sensorNamePrefix;
        return $this;
    }
    /**
     * Get SensorNameBase value
     * @return string|null
     */
    public function getSensorNameBase()
    {
        return $this->SensorNameBase;
    }
    /**
     * Set SensorNameBase value
     * @param string $sensorNameBase
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setSensorNameBase($sensorNameBase = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNameBase) && !is_string($sensorNameBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorNameBase)), __LINE__);
        }
        $this->SensorNameBase = $sensorNameBase;
        return $this;
    }
    /**
     * Get SensorNameSuffix value
     * @return string|null
     */
    public function getSensorNameSuffix()
    {
        return $this->SensorNameSuffix;
    }
    /**
     * Set SensorNameSuffix value
     * @param string $sensorNameSuffix
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setSensorNameSuffix($sensorNameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNameSuffix) && !is_string($sensorNameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorNameSuffix)), __LINE__);
        }
        $this->SensorNameSuffix = $sensorNameSuffix;
        return $this;
    }
    /**
     * Get SensorNameToken3 value
     * @return string|null
     */
    public function getSensorNameToken3()
    {
        return $this->SensorNameToken3;
    }
    /**
     * Set SensorNameToken3 value
     * @param string $sensorNameToken3
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setSensorNameToken3($sensorNameToken3 = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNameToken3) && !is_string($sensorNameToken3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorNameToken3)), __LINE__);
        }
        $this->SensorNameToken3 = $sensorNameToken3;
        return $this;
    }
    /**
     * Get SensorNameToken4 value
     * @return string|null
     */
    public function getSensorNameToken4()
    {
        return $this->SensorNameToken4;
    }
    /**
     * Set SensorNameToken4 value
     * @param string $sensorNameToken4
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setSensorNameToken4($sensorNameToken4 = null)
    {
        // validation for constraint: string
        if (!is_null($sensorNameToken4) && !is_string($sensorNameToken4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorNameToken4)), __LINE__);
        }
        $this->SensorNameToken4 = $sensorNameToken4;
        return $this;
    }
    /**
     * Get SensorTypeId value
     * @return string|null
     */
    public function getSensorTypeId()
    {
        return $this->SensorTypeId;
    }
    /**
     * Set SensorTypeId value
     * @param string $sensorTypeId
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setSensorTypeId($sensorTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($sensorTypeId) && !is_string($sensorTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorTypeId)), __LINE__);
        }
        $this->SensorTypeId = $sensorTypeId;
        return $this;
    }
    /**
     * Get SensorName value
     * @return string|null
     */
    public function getSensorName()
    {
        return $this->SensorName;
    }
    /**
     * Set SensorName value
     * @param string $sensorName
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setSensorName($sensorName = null)
    {
        // validation for constraint: string
        if (!is_null($sensorName) && !is_string($sensorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorName)), __LINE__);
        }
        $this->SensorName = $sensorName;
        return $this;
    }
    /**
     * Get DLCode value
     * @return string|null
     */
    public function getDLCode()
    {
        return $this->DLCode;
    }
    /**
     * Set DLCode value
     * @param string $dLCode
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public function setDLCode($dLCode = null)
    {
        // validation for constraint: string
        if (!is_null($dLCode) && !is_string($dLCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dLCode)), __LINE__);
        }
        $this->DLCode = $dLCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateSensorDeviceInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
