<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerListByBranchId StructType
 * @subpackage Structs
 */
class GetCustomerListByBranchId extends AbstractStructBase
{
    /**
     * The branchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $branchId;
    /**
     * The includeTermed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeTermed;
    /**
     * Constructor method for GetCustomerListByBranchId
     * @uses GetCustomerListByBranchId::setBranchId()
     * @uses GetCustomerListByBranchId::setIncludeTermed()
     * @param int $branchId
     * @param bool $includeTermed
     */
    public function __construct($branchId = null, $includeTermed = null)
    {
        $this
            ->setBranchId($branchId)
            ->setIncludeTermed($includeTermed);
    }
    /**
     * Get branchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->branchId;
    }
    /**
     * Set branchId value
     * @param int $branchId
     * @return \CustomerManagement\StructType\GetCustomerListByBranchId
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !is_numeric($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($branchId)), __LINE__);
        }
        $this->branchId = $branchId;
        return $this;
    }
    /**
     * Get includeTermed value
     * @return bool
     */
    public function getIncludeTermed()
    {
        return $this->includeTermed;
    }
    /**
     * Set includeTermed value
     * @param bool $includeTermed
     * @return \CustomerManagement\StructType\GetCustomerListByBranchId
     */
    public function setIncludeTermed($includeTermed = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTermed) && !is_bool($includeTermed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTermed)), __LINE__);
        }
        $this->includeTermed = $includeTermed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetCustomerListByBranchId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
