<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CameraWirelessSettings StructType
 * @subpackage Structs
 */
class CameraWirelessSettings extends AbstractStructBase
{
    /**
     * The EncryptionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EncryptionType;
    /**
     * The EncryptionAlgorithm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EncryptionAlgorithm;
    /**
     * The SSID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSID;
    /**
     * The EncryptionKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EncryptionKey;
    /**
     * Constructor method for CameraWirelessSettings
     * @uses CameraWirelessSettings::setEncryptionType()
     * @uses CameraWirelessSettings::setEncryptionAlgorithm()
     * @uses CameraWirelessSettings::setSSID()
     * @uses CameraWirelessSettings::setEncryptionKey()
     * @param string $encryptionType
     * @param string $encryptionAlgorithm
     * @param string $sSID
     * @param string $encryptionKey
     */
    public function __construct($encryptionType = null, $encryptionAlgorithm = null, $sSID = null, $encryptionKey = null)
    {
        $this
            ->setEncryptionType($encryptionType)
            ->setEncryptionAlgorithm($encryptionAlgorithm)
            ->setSSID($sSID)
            ->setEncryptionKey($encryptionKey);
    }
    /**
     * Get EncryptionType value
     * @return string
     */
    public function getEncryptionType()
    {
        return $this->EncryptionType;
    }
    /**
     * Set EncryptionType value
     * @uses \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encryptionType
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public function setEncryptionType($encryptionType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\WiFiEncryptionTypeEnum::valueIsValid($encryptionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $encryptionType, implode(', ', \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::getValidValues())), __LINE__);
        }
        $this->EncryptionType = $encryptionType;
        return $this;
    }
    /**
     * Get EncryptionAlgorithm value
     * @return string
     */
    public function getEncryptionAlgorithm()
    {
        return $this->EncryptionAlgorithm;
    }
    /**
     * Set EncryptionAlgorithm value
     * @uses \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encryptionAlgorithm
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public function setEncryptionAlgorithm($encryptionAlgorithm = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::valueIsValid($encryptionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $encryptionAlgorithm, implode(', ', \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::getValidValues())), __LINE__);
        }
        $this->EncryptionAlgorithm = $encryptionAlgorithm;
        return $this;
    }
    /**
     * Get SSID value
     * @return string|null
     */
    public function getSSID()
    {
        return $this->SSID;
    }
    /**
     * Set SSID value
     * @param string $sSID
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public function setSSID($sSID = null)
    {
        // validation for constraint: string
        if (!is_null($sSID) && !is_string($sSID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSID)), __LINE__);
        }
        $this->SSID = $sSID;
        return $this;
    }
    /**
     * Get EncryptionKey value
     * @return string|null
     */
    public function getEncryptionKey()
    {
        return $this->EncryptionKey;
    }
    /**
     * Set EncryptionKey value
     * @param string $encryptionKey
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public function setEncryptionKey($encryptionKey = null)
    {
        // validation for constraint: string
        if (!is_null($encryptionKey) && !is_string($encryptionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encryptionKey)), __LINE__);
        }
        $this->EncryptionKey = $encryptionKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CameraWirelessSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
