<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerSummary ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerSummary extends AbstractStructArrayBase
{
    /**
     * The CustomerSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\CustomerSummary[]
     */
    public $CustomerSummary;
    /**
     * Constructor method for ArrayOfCustomerSummary
     * @uses ArrayOfCustomerSummary::setCustomerSummary()
     * @param \CustomerManagement\StructType\CustomerSummary[] $customerSummary
     */
    public function __construct(array $customerSummary = array())
    {
        $this
            ->setCustomerSummary($customerSummary);
    }
    /**
     * Get CustomerSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\CustomerSummary[]|null
     */
    public function getCustomerSummary()
    {
        return isset($this->CustomerSummary) ? $this->CustomerSummary : null;
    }
    /**
     * Set CustomerSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerSummary[] $customerSummary
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerSummary
     */
    public function setCustomerSummary(array $customerSummary = array())
    {
        foreach ($customerSummary as $arrayOfCustomerSummaryCustomerSummaryItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerSummaryCustomerSummaryItem instanceof \CustomerManagement\StructType\CustomerSummary) {
                throw new \InvalidArgumentException(sprintf('The CustomerSummary property can only contain items of \CustomerManagement\StructType\CustomerSummary, "%s" given', is_object($arrayOfCustomerSummaryCustomerSummaryItem) ? get_class($arrayOfCustomerSummaryCustomerSummaryItem) : gettype($arrayOfCustomerSummaryCustomerSummaryItem)), __LINE__);
            }
        }
        if (is_null($customerSummary) || (is_array($customerSummary) && empty($customerSummary))) {
            unset($this->CustomerSummary);
        } else {
            $this->CustomerSummary = $customerSummary;
        }
        return $this;
    }
    /**
     * Add item to CustomerSummary value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerSummary $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerSummary
     */
    public function addToCustomerSummary(\CustomerManagement\StructType\CustomerSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\CustomerSummary) {
            throw new \InvalidArgumentException(sprintf('The CustomerSummary property can only contain items of \CustomerManagement\StructType\CustomerSummary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerSummary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\CustomerSummary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\CustomerSummary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\CustomerSummary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\CustomerSummary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\CustomerSummary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerSummary
     */
    public function getAttributeName()
    {
        return 'CustomerSummary';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
