<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferAccountInput StructType
 * @subpackage Structs
 */
class TransferAccountInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DestinationDealerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DestinationDealerId;
    /**
     * Constructor method for TransferAccountInput
     * @uses TransferAccountInput::setCustomerId()
     * @uses TransferAccountInput::setDestinationDealerId()
     * @param int $customerId
     * @param int $destinationDealerId
     */
    public function __construct($customerId = null, $destinationDealerId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDestinationDealerId($destinationDealerId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\TransferAccountInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DestinationDealerId value
     * @return int
     */
    public function getDestinationDealerId()
    {
        return $this->DestinationDealerId;
    }
    /**
     * Set DestinationDealerId value
     * @param int $destinationDealerId
     * @return \CustomerManagement\StructType\TransferAccountInput
     */
    public function setDestinationDealerId($destinationDealerId = null)
    {
        // validation for constraint: int
        if (!is_null($destinationDealerId) && !is_numeric($destinationDealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationDealerId)), __LINE__);
        }
        $this->DestinationDealerId = $destinationDealerId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\TransferAccountInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
