<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerListDwTroubleConditionItem StructType
 * @subpackage Structs
 */
class CustomerListDwTroubleConditionItem extends BaseTroubleConditionMuteMatch
{
    /**
     * The TroubleConditionGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TroubleConditionGroup;
    /**
     * The DeviceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeviceType;
    /**
     * The DeviceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The TroubleConditionStartUtc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TroubleConditionStartUtc;
    /**
     * The TroubleConditionDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \CustomerManagement\StructType\TimeSpan
     */
    public $TroubleConditionDuration;
    /**
     * Constructor method for CustomerListDwTroubleConditionItem
     * @uses CustomerListDwTroubleConditionItem::setTroubleConditionGroup()
     * @uses CustomerListDwTroubleConditionItem::setDeviceType()
     * @uses CustomerListDwTroubleConditionItem::setDeviceId()
     * @uses CustomerListDwTroubleConditionItem::setTroubleConditionStartUtc()
     * @uses CustomerListDwTroubleConditionItem::setTroubleConditionDuration()
     * @param string $troubleConditionGroup
     * @param string $deviceType
     * @param int $deviceId
     * @param string $troubleConditionStartUtc
     * @param \CustomerManagement\StructType\TimeSpan $troubleConditionDuration
     */
    public function __construct($troubleConditionGroup = null, $deviceType = null, $deviceId = null, $troubleConditionStartUtc = null, \CustomerManagement\StructType\TimeSpan $troubleConditionDuration = null)
    {
        $this
            ->setTroubleConditionGroup($troubleConditionGroup)
            ->setDeviceType($deviceType)
            ->setDeviceId($deviceId)
            ->setTroubleConditionStartUtc($troubleConditionStartUtc)
            ->setTroubleConditionDuration($troubleConditionDuration);
    }
    /**
     * Get TroubleConditionGroup value
     * @return string
     */
    public function getTroubleConditionGroup()
    {
        return $this->TroubleConditionGroup;
    }
    /**
     * Set TroubleConditionGroup value
     * @uses \CustomerManagement\EnumType\TroubleConditionGroupEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\TroubleConditionGroupEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $troubleConditionGroup
     * @return \CustomerManagement\StructType\CustomerListDwTroubleConditionItem
     */
    public function setTroubleConditionGroup($troubleConditionGroup = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\TroubleConditionGroupEnum::valueIsValid($troubleConditionGroup)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $troubleConditionGroup, implode(', ', \CustomerManagement\EnumType\TroubleConditionGroupEnum::getValidValues())), __LINE__);
        }
        $this->TroubleConditionGroup = $troubleConditionGroup;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \CustomerManagement\StructType\CustomerListDwTroubleConditionItem
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceType, implode(', ', \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\CustomerListDwTroubleConditionItem
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !is_numeric($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get TroubleConditionStartUtc value
     * @return string
     */
    public function getTroubleConditionStartUtc()
    {
        return $this->TroubleConditionStartUtc;
    }
    /**
     * Set TroubleConditionStartUtc value
     * @param string $troubleConditionStartUtc
     * @return \CustomerManagement\StructType\CustomerListDwTroubleConditionItem
     */
    public function setTroubleConditionStartUtc($troubleConditionStartUtc = null)
    {
        // validation for constraint: string
        if (!is_null($troubleConditionStartUtc) && !is_string($troubleConditionStartUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($troubleConditionStartUtc)), __LINE__);
        }
        $this->TroubleConditionStartUtc = $troubleConditionStartUtc;
        return $this;
    }
    /**
     * Get TroubleConditionDuration value
     * @return \CustomerManagement\StructType\TimeSpan
     */
    public function getTroubleConditionDuration()
    {
        return $this->TroubleConditionDuration;
    }
    /**
     * Set TroubleConditionDuration value
     * @param \CustomerManagement\StructType\TimeSpan $troubleConditionDuration
     * @return \CustomerManagement\StructType\CustomerListDwTroubleConditionItem
     */
    public function setTroubleConditionDuration(\CustomerManagement\StructType\TimeSpan $troubleConditionDuration = null)
    {
        $this->TroubleConditionDuration = $troubleConditionDuration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CustomerListDwTroubleConditionItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
