<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetGsmBandSelection StructType
 * @subpackage Structs
 */
class SetGsmBandSelection extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $newValue;
    /**
     * Constructor method for SetGsmBandSelection
     * @uses SetGsmBandSelection::setCustomerId()
     * @uses SetGsmBandSelection::setNewValue()
     * @param int $customerId
     * @param string $newValue
     */
    public function __construct($customerId = null, $newValue = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewValue($newValue);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetGsmBandSelection
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newValue value
     * @return string
     */
    public function getNewValue()
    {
        return $this->newValue;
    }
    /**
     * Set newValue value
     * @uses \CustomerManagement\EnumType\GsmBandSelectionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\GsmBandSelectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newValue
     * @return \CustomerManagement\StructType\SetGsmBandSelection
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\GsmBandSelectionEnum::valueIsValid($newValue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $newValue, implode(', ', \CustomerManagement\EnumType\GsmBandSelectionEnum::getValidValues())), __LINE__);
        }
        $this->newValue = $newValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SetGsmBandSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
