<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerListWithTroubleConditionsInput StructType
 * @subpackage Structs
 */
class GetCustomerListWithTroubleConditionsInput extends AbstractStructBase
{
    /**
     * The CallerVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallerVersion;
    /**
     * The Conditions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum
     */
    public $Conditions;
    /**
     * Constructor method for GetCustomerListWithTroubleConditionsInput
     * @uses GetCustomerListWithTroubleConditionsInput::setCallerVersion()
     * @uses GetCustomerListWithTroubleConditionsInput::setConditions()
     * @param int $callerVersion
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions
     */
    public function __construct($callerVersion = null, \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions = null)
    {
        $this
            ->setCallerVersion($callerVersion)
            ->setConditions($conditions);
    }
    /**
     * Get CallerVersion value
     * @return int
     */
    public function getCallerVersion()
    {
        return $this->CallerVersion;
    }
    /**
     * Set CallerVersion value
     * @param int $callerVersion
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setCallerVersion($callerVersion = null)
    {
        // validation for constraint: int
        if (!is_null($callerVersion) && !is_numeric($callerVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($callerVersion)), __LINE__);
        }
        $this->CallerVersion = $callerVersion;
        return $this;
    }
    /**
     * Get Conditions value
     * @return \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum|null
     */
    public function getConditions()
    {
        return $this->Conditions;
    }
    /**
     * Set Conditions value
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setConditions(\CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions = null)
    {
        $this->Conditions = $conditions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
