<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for TroubleConditionGroupEnum EnumType
 * @subpackage Enumerations
 */
class TroubleConditionGroupEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'CriticalSystemIssue'
     * @return string 'CriticalSystemIssue'
     */
    const VALUE_CRITICAL_SYSTEM_ISSUE = 'CriticalSystemIssue';
    /**
     * Constant for value 'SystemCondition'
     * @return string 'SystemCondition'
     */
    const VALUE_SYSTEM_CONDITION = 'SystemCondition';
    /**
     * Constant for value 'EngagementIssue'
     * @return string 'EngagementIssue'
     */
    const VALUE_ENGAGEMENT_ISSUE = 'EngagementIssue';
    /**
     * Constant for value 'CentralStationCondition'
     * @return string 'CentralStationCondition'
     */
    const VALUE_CENTRAL_STATION_CONDITION = 'CentralStationCondition';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_CRITICAL_SYSTEM_ISSUE
     * @uses self::VALUE_SYSTEM_CONDITION
     * @uses self::VALUE_ENGAGEMENT_ISSUE
     * @uses self::VALUE_CENTRAL_STATION_CONDITION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_CRITICAL_SYSTEM_ISSUE,
            self::VALUE_SYSTEM_CONDITION,
            self::VALUE_ENGAGEMENT_ISSUE,
            self::VALUE_CENTRAL_STATION_CONDITION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
