<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseTroubleConditionMuteMatch StructType
 * @subpackage Structs
 */
abstract class BaseTroubleConditionMuteMatch extends AbstractStructBase
{
    /**
     * The TroubleCondition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TroubleCondition;
    /**
     * Constructor method for BaseTroubleConditionMuteMatch
     * @uses BaseTroubleConditionMuteMatch::setTroubleCondition()
     * @param string $troubleCondition
     */
    public function __construct($troubleCondition = null)
    {
        $this
            ->setTroubleCondition($troubleCondition);
    }
    /**
     * Get TroubleCondition value
     * @return string
     */
    public function getTroubleCondition()
    {
        return $this->TroubleCondition;
    }
    /**
     * Set TroubleCondition value
     * @uses \CustomerManagement\EnumType\TroubleConditionTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\TroubleConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $troubleCondition
     * @return \CustomerManagement\StructType\BaseTroubleConditionMuteMatch
     */
    public function setTroubleCondition($troubleCondition = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\TroubleConditionTypeEnum::valueIsValid($troubleCondition)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $troubleCondition, implode(', ', \CustomerManagement\EnumType\TroubleConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->TroubleCondition = $troubleCondition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\BaseTroubleConditionMuteMatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
