<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Turn ServiceType
 * @subpackage Services
 */
class Turn extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named TurnOffAccessCodeLock
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Disables Access Code Lock on the panel (only for Concord) so that the alarm.com radio can control the system. installerCode must be 4 digits. | Disables Access Code Lock on the panel (only for Concord) so that the alarm.com radio can
     * control the system. installerCode must be 4 digits. | Disables Access Code Lock on the panel (only for Concord) so that the alarm.com radio can control the system. installerCode must be 4 digits.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\TurnOffAccessCodeLock $parameters
     * @return \CustomerManagement\StructType\TurnOffAccessCodeLockResponse|bool
     */
    public function TurnOffAccessCodeLock(\CustomerManagement\StructType\TurnOffAccessCodeLock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TurnOffAccessCodeLock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\TurnOffAccessCodeLockResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
