<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for ActivateModemOutput EnumType
 * Meta informations extracted from the WSDL
 * - type: tns:ActivateModemOutput
 * @subpackage Enumerations
 */
class ActivateModemOutput
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'ModemNotFound'
     * @return string 'ModemNotFound'
     */
    const VALUE_MODEM_NOT_FOUND = 'ModemNotFound';
    /**
     * Constant for value 'AlreadyActivated'
     * @return string 'AlreadyActivated'
     */
    const VALUE_ALREADY_ACTIVATED = 'AlreadyActivated';
    /**
     * Constant for value 'ActivationRequestSubmitted'
     * @return string 'ActivationRequestSubmitted'
     */
    const VALUE_ACTIVATION_REQUEST_SUBMITTED = 'ActivationRequestSubmitted';
    /**
     * Constant for value 'ErrorActivating'
     * @return string 'ErrorActivating'
     */
    const VALUE_ERROR_ACTIVATING = 'ErrorActivating';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_MODEM_NOT_FOUND
     * @uses self::VALUE_ALREADY_ACTIVATED
     * @uses self::VALUE_ACTIVATION_REQUEST_SUBMITTED
     * @uses self::VALUE_ERROR_ACTIVATING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_MODEM_NOT_FOUND,
            self::VALUE_ALREADY_ACTIVATED,
            self::VALUE_ACTIVATION_REQUEST_SUBMITTED,
            self::VALUE_ERROR_ACTIVATING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
