<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupCustomerIdForDealer StructType
 * @subpackage Structs
 */
class LookupCustomerIdForDealer extends AbstractStructBase
{
    /**
     * The dealerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dealerId;
    /**
     * The receiverPhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $receiverPhoneNumber;
    /**
     * The acctNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $acctNumber;
    /**
     * Constructor method for LookupCustomerIdForDealer
     * @uses LookupCustomerIdForDealer::setDealerId()
     * @uses LookupCustomerIdForDealer::setReceiverPhoneNumber()
     * @uses LookupCustomerIdForDealer::setAcctNumber()
     * @param int $dealerId
     * @param string $receiverPhoneNumber
     * @param string $acctNumber
     */
    public function __construct($dealerId = null, $receiverPhoneNumber = null, $acctNumber = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setReceiverPhoneNumber($receiverPhoneNumber)
            ->setAcctNumber($acctNumber);
    }
    /**
     * Get dealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->dealerId;
    }
    /**
     * Set dealerId value
     * @param int $dealerId
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealer
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !is_numeric($dealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dealerId)), __LINE__);
        }
        $this->dealerId = $dealerId;
        return $this;
    }
    /**
     * Get receiverPhoneNumber value
     * @return string|null
     */
    public function getReceiverPhoneNumber()
    {
        return $this->receiverPhoneNumber;
    }
    /**
     * Set receiverPhoneNumber value
     * @param string $receiverPhoneNumber
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealer
     */
    public function setReceiverPhoneNumber($receiverPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhoneNumber) && !is_string($receiverPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverPhoneNumber)), __LINE__);
        }
        $this->receiverPhoneNumber = $receiverPhoneNumber;
        return $this;
    }
    /**
     * Get acctNumber value
     * @return string|null
     */
    public function getAcctNumber()
    {
        return $this->acctNumber;
    }
    /**
     * Set acctNumber value
     * @param string $acctNumber
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealer
     */
    public function setAcctNumber($acctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($acctNumber) && !is_string($acctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acctNumber)), __LINE__);
        }
        $this->acctNumber = $acctNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
