<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSimStatusDuringActivationOutput StructType
 * @subpackage Structs
 */
class GetSimStatusDuringActivationOutput extends AbstractStructBase
{
    /**
     * The SimStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SimStatus;
    /**
     * The ErrorStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorStatus;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetSimStatusDuringActivationOutput
     * @uses GetSimStatusDuringActivationOutput::setSimStatus()
     * @uses GetSimStatusDuringActivationOutput::setErrorStatus()
     * @uses GetSimStatusDuringActivationOutput::setSuccess()
     * @uses GetSimStatusDuringActivationOutput::setErrorMessage()
     * @param string $simStatus
     * @param string $errorStatus
     * @param bool $success
     * @param string $errorMessage
     */
    public function __construct($simStatus = null, $errorStatus = null, $success = null, $errorMessage = null)
    {
        $this
            ->setSimStatus($simStatus)
            ->setErrorStatus($errorStatus)
            ->setSuccess($success)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get SimStatus value
     * @return string
     */
    public function getSimStatus()
    {
        return $this->SimStatus;
    }
    /**
     * Set SimStatus value
     * @uses \CustomerManagement\EnumType\SimStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\SimStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $simStatus
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public function setSimStatus($simStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\SimStatusEnum::valueIsValid($simStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $simStatus, implode(', ', \CustomerManagement\EnumType\SimStatusEnum::getValidValues())), __LINE__);
        }
        $this->SimStatus = $simStatus;
        return $this;
    }
    /**
     * Get ErrorStatus value
     * @return string
     */
    public function getErrorStatus()
    {
        return $this->ErrorStatus;
    }
    /**
     * Set ErrorStatus value
     * @uses \CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorStatus
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public function setErrorStatus($errorStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum::valueIsValid($errorStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorStatus, implode(', ', \CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum::getValidValues())), __LINE__);
        }
        $this->ErrorStatus = $errorStatus;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public function setSuccess($success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
