<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddSensorDeviceFor2GigInput StructType
 * @subpackage Structs
 */
class AddSensorDeviceFor2GigInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SensorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorId;
    /**
     * The Reports
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Reports;
    /**
     * The Supervised
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Supervised;
    /**
     * The SensorType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorType;
    /**
     * The EquipmentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EquipmentType;
    /**
     * The EquipmentCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EquipmentCode;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The EquipmentAge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EquipmentAge;
    /**
     * The SensorLoopNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SensorLoopNumber;
    /**
     * The DialerDelay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DialerDelay;
    /**
     * The VoiceDescriptors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfString
     */
    public $VoiceDescriptors;
    /**
     * The Chime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Chime;
    /**
     * Constructor method for AddSensorDeviceFor2GigInput
     * @uses AddSensorDeviceFor2GigInput::setCustomerId()
     * @uses AddSensorDeviceFor2GigInput::setSensorId()
     * @uses AddSensorDeviceFor2GigInput::setReports()
     * @uses AddSensorDeviceFor2GigInput::setSupervised()
     * @uses AddSensorDeviceFor2GigInput::setSensorType()
     * @uses AddSensorDeviceFor2GigInput::setEquipmentType()
     * @uses AddSensorDeviceFor2GigInput::setEquipmentCode()
     * @uses AddSensorDeviceFor2GigInput::setSerialNumber()
     * @uses AddSensorDeviceFor2GigInput::setEquipmentAge()
     * @uses AddSensorDeviceFor2GigInput::setSensorLoopNumber()
     * @uses AddSensorDeviceFor2GigInput::setDialerDelay()
     * @uses AddSensorDeviceFor2GigInput::setVoiceDescriptors()
     * @uses AddSensorDeviceFor2GigInput::setChime()
     * @param int $customerId
     * @param int $sensorId
     * @param bool $reports
     * @param bool $supervised
     * @param string $sensorType
     * @param string $equipmentType
     * @param string $equipmentCode
     * @param string $serialNumber
     * @param string $equipmentAge
     * @param string $sensorLoopNumber
     * @param string $dialerDelay
     * @param \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors
     * @param string $chime
     */
    public function __construct($customerId = null, $sensorId = null, $reports = null, $supervised = null, $sensorType = null, $equipmentType = null, $equipmentCode = null, $serialNumber = null, $equipmentAge = null, $sensorLoopNumber = null, $dialerDelay = null, \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors = null, $chime = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSensorId($sensorId)
            ->setReports($reports)
            ->setSupervised($supervised)
            ->setSensorType($sensorType)
            ->setEquipmentType($equipmentType)
            ->setEquipmentCode($equipmentCode)
            ->setSerialNumber($serialNumber)
            ->setEquipmentAge($equipmentAge)
            ->setSensorLoopNumber($sensorLoopNumber)
            ->setDialerDelay($dialerDelay)
            ->setVoiceDescriptors($voiceDescriptors)
            ->setChime($chime);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SensorId value
     * @return int
     */
    public function getSensorId()
    {
        return $this->SensorId;
    }
    /**
     * Set SensorId value
     * @param int $sensorId
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setSensorId($sensorId = null)
    {
        // validation for constraint: int
        if (!is_null($sensorId) && !is_numeric($sensorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sensorId)), __LINE__);
        }
        $this->SensorId = $sensorId;
        return $this;
    }
    /**
     * Get Reports value
     * @return bool
     */
    public function getReports()
    {
        return $this->Reports;
    }
    /**
     * Set Reports value
     * @param bool $reports
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setReports($reports = null)
    {
        $this->Reports = $reports;
        return $this;
    }
    /**
     * Get Supervised value
     * @return bool
     */
    public function getSupervised()
    {
        return $this->Supervised;
    }
    /**
     * Set Supervised value
     * @param bool $supervised
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setSupervised($supervised = null)
    {
        $this->Supervised = $supervised;
        return $this;
    }
    /**
     * Get SensorType value
     * @return string|null
     */
    public function getSensorType()
    {
        return $this->SensorType;
    }
    /**
     * Set SensorType value
     * @param string $sensorType
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setSensorType($sensorType = null)
    {
        // validation for constraint: string
        if (!is_null($sensorType) && !is_string($sensorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorType)), __LINE__);
        }
        $this->SensorType = $sensorType;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return string|null
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param string $equipmentType
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setEquipmentType($equipmentType = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentType) && !is_string($equipmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentType)), __LINE__);
        }
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get EquipmentCode value
     * @return string|null
     */
    public function getEquipmentCode()
    {
        return $this->EquipmentCode;
    }
    /**
     * Set EquipmentCode value
     * @param string $equipmentCode
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setEquipmentCode($equipmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentCode) && !is_string($equipmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentCode)), __LINE__);
        }
        $this->EquipmentCode = $equipmentCode;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get EquipmentAge value
     * @return string|null
     */
    public function getEquipmentAge()
    {
        return $this->EquipmentAge;
    }
    /**
     * Set EquipmentAge value
     * @param string $equipmentAge
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setEquipmentAge($equipmentAge = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentAge) && !is_string($equipmentAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentAge)), __LINE__);
        }
        $this->EquipmentAge = $equipmentAge;
        return $this;
    }
    /**
     * Get SensorLoopNumber value
     * @return string|null
     */
    public function getSensorLoopNumber()
    {
        return $this->SensorLoopNumber;
    }
    /**
     * Set SensorLoopNumber value
     * @param string $sensorLoopNumber
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setSensorLoopNumber($sensorLoopNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sensorLoopNumber) && !is_string($sensorLoopNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sensorLoopNumber)), __LINE__);
        }
        $this->SensorLoopNumber = $sensorLoopNumber;
        return $this;
    }
    /**
     * Get DialerDelay value
     * @return string|null
     */
    public function getDialerDelay()
    {
        return $this->DialerDelay;
    }
    /**
     * Set DialerDelay value
     * @param string $dialerDelay
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setDialerDelay($dialerDelay = null)
    {
        // validation for constraint: string
        if (!is_null($dialerDelay) && !is_string($dialerDelay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dialerDelay)), __LINE__);
        }
        $this->DialerDelay = $dialerDelay;
        return $this;
    }
    /**
     * Get VoiceDescriptors value
     * @return \CustomerManagement\ArrayType\ArrayOfString|null
     */
    public function getVoiceDescriptors()
    {
        return $this->VoiceDescriptors;
    }
    /**
     * Set VoiceDescriptors value
     * @param \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setVoiceDescriptors(\CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors = null)
    {
        $this->VoiceDescriptors = $voiceDescriptors;
        return $this;
    }
    /**
     * Get Chime value
     * @return string|null
     */
    public function getChime()
    {
        return $this->Chime;
    }
    /**
     * Set Chime value
     * @param string $chime
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public function setChime($chime = null)
    {
        // validation for constraint: string
        if (!is_null($chime) && !is_string($chime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chime)), __LINE__);
        }
        $this->Chime = $chime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
