<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for NotificationTypeEnum EnumType
 * @subpackage Enumerations
 */
class NotificationTypeEnum
{
    /**
     * Constant for value 'ImageSensorAlarmUpload'
     * @return string 'ImageSensorAlarmUpload'
     */
    const VALUE_IMAGE_SENSOR_ALARM_UPLOAD = 'ImageSensorAlarmUpload';
    /**
     * Constant for value 'ImageSensorManualUpload'
     * @return string 'ImageSensorManualUpload'
     */
    const VALUE_IMAGE_SENSOR_MANUAL_UPLOAD = 'ImageSensorManualUpload';
    /**
     * Constant for value 'SensorLeftOpenSchedule'
     * @return string 'SensorLeftOpenSchedule'
     */
    const VALUE_SENSOR_LEFT_OPEN_SCHEDULE = 'SensorLeftOpenSchedule';
    /**
     * Constant for value 'ArmingReminder'
     * @return string 'ArmingReminder'
     */
    const VALUE_ARMING_REMINDER = 'ArmingReminder';
    /**
     * Constant for value 'ArmingEvent'
     * @return string 'ArmingEvent'
     */
    const VALUE_ARMING_EVENT = 'ArmingEvent';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IMAGE_SENSOR_ALARM_UPLOAD
     * @uses self::VALUE_IMAGE_SENSOR_MANUAL_UPLOAD
     * @uses self::VALUE_SENSOR_LEFT_OPEN_SCHEDULE
     * @uses self::VALUE_ARMING_REMINDER
     * @uses self::VALUE_ARMING_EVENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMAGE_SENSOR_ALARM_UPLOAD,
            self::VALUE_IMAGE_SENSOR_MANUAL_UPLOAD,
            self::VALUE_SENSOR_LEFT_OPEN_SCHEDULE,
            self::VALUE_ARMING_REMINDER,
            self::VALUE_ARMING_EVENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
