<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Request ServiceType
 * @subpackage Services
 */
class Request extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RequestUpdatedEquipmentList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Request updated equipment list for an NX panel. | Request updated equipment list for an NX panel. | Request updated equipment list for an NX panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestUpdatedEquipmentList $parameters
     * @return \CustomerManagement\StructType\RequestUpdatedEquipmentListResponse|bool
     */
    public function RequestUpdatedEquipmentList(\CustomerManagement\StructType\RequestUpdatedEquipmentList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestUpdatedEquipmentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestAvailableWifiNetworkNames
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Request available wifi network names. | Request available wifi network names. | Request available wifi network names.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestAvailableWifiNetworkNames $parameters
     * @return \CustomerManagement\StructType\RequestAvailableWifiNetworkNamesResponse|bool
     */
    public function RequestAvailableWifiNetworkNames(\CustomerManagement\StructType\RequestAvailableWifiNetworkNames $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestAvailableWifiNetworkNames($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestRoundTripCsTest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestRoundTripCsTest $parameters
     * @return \CustomerManagement\StructType\RequestRoundTripCsTestResponse|bool
     */
    public function RequestRoundTripCsTest(\CustomerManagement\StructType\RequestRoundTripCsTest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestRoundTripCsTest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestSignalStrength
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestSignalStrength $parameters
     * @return \CustomerManagement\StructType\RequestSignalStrengthResponse|bool
     */
    public function RequestSignalStrength(\CustomerManagement\StructType\RequestSignalStrength $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestSignalStrength($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestFirmwareVersionCommand
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Sends request firmware version command to the module | Sends request firmware version command to the module | Sends request firmware version command to the module
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestFirmwareVersionCommand $parameters
     * @return \CustomerManagement\StructType\RequestFirmwareVersionCommandResponse|bool
     */
    public function RequestFirmwareVersionCommand(\CustomerManagement\StructType\RequestFirmwareVersionCommand $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestFirmwareVersionCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestSensorNames
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Sends a command to the module, asking it to send the sensor names that are programmed in the panel. NOTE: This will overwrite the sensor names that the user has entered on the website. The waitUntilPanelConnects controls whether the
     * command is sent immediately (false) or if we should wait until the modules connects to the server for something else to send the command (true). If this is a new customer, you should almost certainly pass true. | Sends a command to the module, asking
     * it to send the sensor names that are programmed in the panel. NOTE: This will overwrite the sensor names that the user has entered on the website. The waitUntilPanelConnects controls whether the command is sent immediately (false) or if we should
     * wait until the modules connects to the server for something else to send the command (true). If this is a new customer, you should almost certainly pass true. | Sends a command to the module, asking it to send the sensor names that are programmed in
     * the panel. NOTE: This will overwrite the sensor names that the user has entered on the website. The waitUntilPanelConnects controls whether the command is sent immediately (false) or if we should wait until the modules connects to the server for
     * something else to send the command (true). If this is a new customer, you should almost certainly pass true.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestSensorNames $parameters
     * @return \CustomerManagement\StructType\RequestSensorNamesResponse|bool
     */
    public function RequestSensorNames(\CustomerManagement\StructType\RequestSensorNames $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestSensorNames($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestUploadOfPanelSettings
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Requests an upload from the panel. Note: this is beta and the method signature may change. | Requests an upload from the panel. Note: this is beta and the method signature may change. | Requests an upload from the panel. Note: this
     * is beta and the method signature may change.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestUploadOfPanelSettings $parameters
     * @return \CustomerManagement\StructType\RequestUploadOfPanelSettingsResponse|bool
     */
    public function RequestUploadOfPanelSettings(\CustomerManagement\StructType\RequestUploadOfPanelSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestUploadOfPanelSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestZWaveEquipmentList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Requests the z-wave equipment list from the panel. | Requests the z-wave equipment list from the panel. | Requests the z-wave equipment list from the panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestZWaveEquipmentList $parameters
     * @return \CustomerManagement\StructType\RequestZWaveEquipmentListResponse|bool
     */
    public function RequestZWaveEquipmentList(\CustomerManagement\StructType\RequestZWaveEquipmentList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestZWaveEquipmentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestFirmwareUpgradeQolsys
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Requests a firmware update for a qolsys panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestFirmwareUpgradeQolsys $parameters
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeQolsysResponse|bool
     */
    public function RequestFirmwareUpgradeQolsys(\CustomerManagement\StructType\RequestFirmwareUpgradeQolsys $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestFirmwareUpgradeQolsys($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestFirmwareUpgrade
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Requests a firmware update. A charge may be incurred when upgradePath: Standard is selected, however only some upgrades are eligible for Broadband. For questions please contact your Alarm.com Sales Representative. | Requests a
     * firmware update. A charge may be incurred when upgradePath: Standard is selected, however only some upgrades are eligible for Broadband. For questions please contact your Alarm.com Sales Representative. | Requests a firmware update. A charge may be
     * incurred when upgradePath: Standard is selected, however only some upgrades are eligible for Broadband. For questions please contact your Alarm.com Sales Representative.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\RequestFirmwareUpgrade $parameters
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeResponse|bool
     */
    public function RequestFirmwareUpgrade(\CustomerManagement\StructType\RequestFirmwareUpgrade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestFirmwareUpgrade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\RequestAvailableWifiNetworkNamesResponse|\CustomerManagement\StructType\RequestFirmwareUpgradeQolsysResponse|\CustomerManagement\StructType\RequestFirmwareUpgradeResponse|\CustomerManagement\StructType\RequestFirmwareVersionCommandResponse|\CustomerManagement\StructType\RequestRoundTripCsTestResponse|\CustomerManagement\StructType\RequestSensorNamesResponse|\CustomerManagement\StructType\RequestSignalStrengthResponse|\CustomerManagement\StructType\RequestUpdatedEquipmentListResponse|\CustomerManagement\StructType\RequestUploadOfPanelSettingsResponse|\CustomerManagement\StructType\RequestZWaveEquipmentListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
