<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCommunicationSettingOutput StructType
 * @subpackage Structs
 */
class GetCommunicationSettingOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The DualPathMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DualPathMode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetCommunicationSettingOutput
     * @uses GetCommunicationSettingOutput::setSuccess()
     * @uses GetCommunicationSettingOutput::setDualPathMode()
     * @uses GetCommunicationSettingOutput::setErrorMessage()
     * @param bool $success
     * @param string $dualPathMode
     * @param string $errorMessage
     */
    public function __construct($success = null, $dualPathMode = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setDualPathMode($dualPathMode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetCommunicationSettingOutput
     */
    public function setSuccess($success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get DualPathMode value
     * @return string
     */
    public function getDualPathMode()
    {
        return $this->DualPathMode;
    }
    /**
     * Set DualPathMode value
     * @uses \CustomerManagement\EnumType\DualPathModeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DualPathModeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dualPathMode
     * @return \CustomerManagement\StructType\GetCommunicationSettingOutput
     */
    public function setDualPathMode($dualPathMode = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DualPathModeEnum::valueIsValid($dualPathMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dualPathMode, implode(', ', \CustomerManagement\EnumType\DualPathModeEnum::getValidValues())), __LINE__);
        }
        $this->DualPathMode = $dualPathMode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetCommunicationSettingOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetCommunicationSettingOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
