<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CentralStationInfo StructType
 * @subpackage Structs
 */
class CentralStationInfo extends AbstractStructBase
{
    /**
     * The TwoWayVoiceEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TwoWayVoiceEnabled;
    /**
     * The PhoneLinePresent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PhoneLinePresent;
    /**
     * The ForwardingOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ForwardingOption;
    /**
     * The ReceiverPhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPhoneNumber;
    /**
     * The CentralStationPhoneNumberKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CentralStationPhoneNumberKey;
    /**
     * The AccountPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountPrefix;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The EventGroupsToForward
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public $EventGroupsToForward;
    /**
     * Constructor method for CentralStationInfo
     * @uses CentralStationInfo::setTwoWayVoiceEnabled()
     * @uses CentralStationInfo::setPhoneLinePresent()
     * @uses CentralStationInfo::setForwardingOption()
     * @uses CentralStationInfo::setReceiverPhoneNumber()
     * @uses CentralStationInfo::setCentralStationPhoneNumberKey()
     * @uses CentralStationInfo::setAccountPrefix()
     * @uses CentralStationInfo::setAccountNumber()
     * @uses CentralStationInfo::setEventGroupsToForward()
     * @param bool $twoWayVoiceEnabled
     * @param bool $phoneLinePresent
     * @param string $forwardingOption
     * @param string $receiverPhoneNumber
     * @param string $centralStationPhoneNumberKey
     * @param string $accountPrefix
     * @param string $accountNumber
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     */
    public function __construct($twoWayVoiceEnabled = null, $phoneLinePresent = null, $forwardingOption = null, $receiverPhoneNumber = null, $centralStationPhoneNumberKey = null, $accountPrefix = null, $accountNumber = null, \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null)
    {
        $this
            ->setTwoWayVoiceEnabled($twoWayVoiceEnabled)
            ->setPhoneLinePresent($phoneLinePresent)
            ->setForwardingOption($forwardingOption)
            ->setReceiverPhoneNumber($receiverPhoneNumber)
            ->setCentralStationPhoneNumberKey($centralStationPhoneNumberKey)
            ->setAccountPrefix($accountPrefix)
            ->setAccountNumber($accountNumber)
            ->setEventGroupsToForward($eventGroupsToForward);
    }
    /**
     * Get TwoWayVoiceEnabled value
     * @return bool
     */
    public function getTwoWayVoiceEnabled()
    {
        return $this->TwoWayVoiceEnabled;
    }
    /**
     * Set TwoWayVoiceEnabled value
     * @param bool $twoWayVoiceEnabled
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public function setTwoWayVoiceEnabled($twoWayVoiceEnabled = null)
    {
        $this->TwoWayVoiceEnabled = $twoWayVoiceEnabled;
        return $this;
    }
    /**
     * Get PhoneLinePresent value
     * @return bool
     */
    public function getPhoneLinePresent()
    {
        return $this->PhoneLinePresent;
    }
    /**
     * Set PhoneLinePresent value
     * @param bool $phoneLinePresent
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public function setPhoneLinePresent($phoneLinePresent = null)
    {
        $this->PhoneLinePresent = $phoneLinePresent;
        return $this;
    }
    /**
     * Get ForwardingOption value
     * @return string
     */
    public function getForwardingOption()
    {
        return $this->ForwardingOption;
    }
    /**
     * Set ForwardingOption value
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $forwardingOption
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public function setForwardingOption($forwardingOption = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid($forwardingOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $forwardingOption, implode(', ', \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues())), __LINE__);
        }
        $this->ForwardingOption = $forwardingOption;
        return $this;
    }
    /**
     * Get ReceiverPhoneNumber value
     * @return string|null
     */
    public function getReceiverPhoneNumber()
    {
        return $this->ReceiverPhoneNumber;
    }
    /**
     * Set ReceiverPhoneNumber value
     * @param string $receiverPhoneNumber
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public function setReceiverPhoneNumber($receiverPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhoneNumber) && !is_string($receiverPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverPhoneNumber)), __LINE__);
        }
        $this->ReceiverPhoneNumber = $receiverPhoneNumber;
        return $this;
    }
    /**
     * Get CentralStationPhoneNumberKey value
     * @return string|null
     */
    public function getCentralStationPhoneNumberKey()
    {
        return $this->CentralStationPhoneNumberKey;
    }
    /**
     * Set CentralStationPhoneNumberKey value
     * @param string $centralStationPhoneNumberKey
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public function setCentralStationPhoneNumberKey($centralStationPhoneNumberKey = null)
    {
        // validation for constraint: string
        if (!is_null($centralStationPhoneNumberKey) && !is_string($centralStationPhoneNumberKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($centralStationPhoneNumberKey)), __LINE__);
        }
        $this->CentralStationPhoneNumberKey = $centralStationPhoneNumberKey;
        return $this;
    }
    /**
     * Get AccountPrefix value
     * @return string|null
     */
    public function getAccountPrefix()
    {
        return $this->AccountPrefix;
    }
    /**
     * Set AccountPrefix value
     * @param string $accountPrefix
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public function setAccountPrefix($accountPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($accountPrefix) && !is_string($accountPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountPrefix)), __LINE__);
        }
        $this->AccountPrefix = $accountPrefix;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get EventGroupsToForward value
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum|null
     */
    public function getEventGroupsToForward()
    {
        return $this->EventGroupsToForward;
    }
    /**
     * Set EventGroupsToForward value
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public function setEventGroupsToForward(\CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null)
    {
        $this->EventGroupsToForward = $eventGroupsToForward;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CentralStationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
