<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSolarConnectionInput StructType
 * @subpackage Structs
 */
class CreateSolarConnectionInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SolarProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SolarProvider;
    /**
     * The ExpectedYearlyProduction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExpectedYearlyProduction;
    /**
     * The ConnectionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionId;
    /**
     * Constructor method for CreateSolarConnectionInput
     * @uses CreateSolarConnectionInput::setCustomerId()
     * @uses CreateSolarConnectionInput::setSolarProvider()
     * @uses CreateSolarConnectionInput::setExpectedYearlyProduction()
     * @uses CreateSolarConnectionInput::setConnectionId()
     * @param int $customerId
     * @param string $solarProvider
     * @param float $expectedYearlyProduction
     * @param string $connectionId
     */
    public function __construct($customerId = null, $solarProvider = null, $expectedYearlyProduction = null, $connectionId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSolarProvider($solarProvider)
            ->setExpectedYearlyProduction($expectedYearlyProduction)
            ->setConnectionId($connectionId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SolarProvider value
     * @return string
     */
    public function getSolarProvider()
    {
        return $this->SolarProvider;
    }
    /**
     * Set SolarProvider value
     * @uses \CustomerManagement\EnumType\SolarProviderEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\SolarProviderEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $solarProvider
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public function setSolarProvider($solarProvider = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\SolarProviderEnum::valueIsValid($solarProvider)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $solarProvider, implode(', ', \CustomerManagement\EnumType\SolarProviderEnum::getValidValues())), __LINE__);
        }
        $this->SolarProvider = $solarProvider;
        return $this;
    }
    /**
     * Get ExpectedYearlyProduction value
     * @return float
     */
    public function getExpectedYearlyProduction()
    {
        return $this->ExpectedYearlyProduction;
    }
    /**
     * Set ExpectedYearlyProduction value
     * @param float $expectedYearlyProduction
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public function setExpectedYearlyProduction($expectedYearlyProduction = null)
    {
        $this->ExpectedYearlyProduction = $expectedYearlyProduction;
        return $this;
    }
    /**
     * Get ConnectionId value
     * @return string|null
     */
    public function getConnectionId()
    {
        return $this->ConnectionId;
    }
    /**
     * Set ConnectionId value
     * @param string $connectionId
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public function setConnectionId($connectionId = null)
    {
        // validation for constraint: string
        if (!is_null($connectionId) && !is_string($connectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionId)), __LINE__);
        }
        $this->ConnectionId = $connectionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
