<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://alarmadmin.alarm.com/WebServices/CustomerManagement.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://alarmadmin.alarm.com/WebServices/CustomerManagement.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \CustomerManagement\ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \CustomerManagement\ServiceType\Add($options);
$add->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for AddExistingLogins operation/method
 */
if ($add->AddExistingLogins(new \CustomerManagement\StructType\AddExistingLogins()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDefaultNotifications operation/method
 */
if ($add->AddDefaultNotifications(new \CustomerManagement\StructType\AddDefaultNotifications()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSensorDevice operation/method
 */
if ($add->AddSensorDevice(new \CustomerManagement\StructType\AddSensorDevice()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSensorDeviceFor2Gig operation/method
 */
if ($add->AddSensorDeviceFor2Gig(new \CustomerManagement\StructType\AddSensorDeviceFor2Gig()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddFobFor2Gig operation/method
 */
if ($add->AddFobFor2Gig(new \CustomerManagement\StructType\AddFobFor2Gig()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSensorGetKeyfobProperties operation/method
 */
if ($add->AddSensorGetKeyfobProperties(new \CustomerManagement\StructType\AddSensorGetKeyfobProperties()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddVideoDevice operation/method
 */
if ($add->AddVideoDevice(new \CustomerManagement\StructType\AddVideoDevice()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddImageSensor operation/method
 */
if ($add->AddImageSensor(new \CustomerManagement\StructType\AddImageSensor()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSensorGetSensorVoiceDescriptors operation/method
 */
if ($add->AddSensorGetSensorVoiceDescriptors(new \CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptors()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSensorGetSensorTypes operation/method
 */
if ($add->AddSensorGetSensorTypes(new \CustomerManagement\StructType\AddSensorGetSensorTypes()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUserCode operation/method
 */
if ($add->AddUserCode(new \CustomerManagement\StructType\AddUserCode()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCustomerToGroup operation/method
 */
if ($add->AddCustomerToGroup(new \CustomerManagement\StructType\AddCustomerToGroup()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCustomerLogin operation/method
 */
if ($add->AddCustomerLogin(new \CustomerManagement\StructType\AddCustomerLogin()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \CustomerManagement\ServiceType\Create($options);
$create->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for CreateNewCustomerWebsiteMessage operation/method
 */
if ($create->CreateNewCustomerWebsiteMessage(new \CustomerManagement\StructType\CreateNewCustomerWebsiteMessage()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateScheduledAppointment operation/method
 */
if ($create->CreateScheduledAppointment(new \CustomerManagement\StructType\CreateScheduledAppointment()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSolarConnection operation/method
 */
if ($create->CreateSolarConnection(new \CustomerManagement\StructType\CreateSolarConnection()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomer operation/method
 */
if ($create->CreateCustomer(new \CustomerManagement\StructType\CreateCustomer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCommitment operation/method
 */
if ($create->CreateCommitment(new \CustomerManagement\StructType\CreateCommitment()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCommitmentForDealer operation/method
 */
if ($create->CreateCommitmentForDealer(new \CustomerManagement\StructType\CreateCommitmentForDealer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomerForDealer operation/method
 */
if ($create->CreateCustomerForDealer(new \CustomerManagement\StructType\CreateCustomerForDealer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateEnterpriseGroup operation/method
 */
if ($create->CreateEnterpriseGroup(new \CustomerManagement\StructType\CreateEnterpriseGroup()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateImageSensorAutoUploadRule operation/method
 */
if ($create->CreateImageSensorAutoUploadRule(new \CustomerManagement\StructType\CreateImageSensorAutoUploadRule()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \CustomerManagement\ServiceType\Delete($options);
$delete->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for DeleteCustomerWebsiteMessage operation/method
 */
if ($delete->DeleteCustomerWebsiteMessage(new \CustomerManagement\StructType\DeleteCustomerWebsiteMessage()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSensorDevice operation/method
 */
if ($delete->DeleteSensorDevice(new \CustomerManagement\StructType\DeleteSensorDevice()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteImageSensor operation/method
 */
if ($delete->DeleteImageSensor(new \CustomerManagement\StructType\DeleteImageSensor()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteVideoDevice operation/method
 */
if ($delete->DeleteVideoDevice(new \CustomerManagement\StructType\DeleteVideoDevice()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCustomerLogin operation/method
 */
if ($delete->DeleteCustomerLogin(new \CustomerManagement\StructType\DeleteCustomerLogin()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \CustomerManagement\ServiceType\Reset($options);
$reset->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for ResetCustomerPassword operation/method
 */
if ($reset->ResetCustomerPassword(new \CustomerManagement\StructType\ResetCustomerPassword()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Sample call for ResetUnexpectedActivity operation/method
 */
if ($reset->ResetUnexpectedActivity(new \CustomerManagement\StructType\ResetUnexpectedActivity()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \CustomerManagement\ServiceType\Update($options);
$update->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for UpdateCustomDevices operation/method
 */
if ($update->UpdateCustomDevices(new \CustomerManagement\StructType\UpdateCustomDevices()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerEnergyProgramEnrollment operation/method
 */
if ($update->UpdateCustomerEnergyProgramEnrollment(new \CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollment()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateUnitDescription operation/method
 */
if ($update->UpdateUnitDescription(new \CustomerManagement\StructType\UpdateUnitDescription()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDeviceName operation/method
 */
if ($update->UpdateDeviceName(new \CustomerManagement\StructType\UpdateDeviceName()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSensorDevice operation/method
 */
if ($update->UpdateSensorDevice(new \CustomerManagement\StructType\UpdateSensorDevice()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSensorTypeIDQolsys operation/method
 */
if ($update->UpdateSensorTypeIDQolsys(new \CustomerManagement\StructType\UpdateSensorTypeIDQolsys()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSensorGroup operation/method
 */
if ($update->UpdateSensorGroup(new \CustomerManagement\StructType\UpdateSensorGroup()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for Update2GigSensorGroup operation/method
 */
if ($update->Update2GigSensorGroup(new \CustomerManagement\StructType\Update2GigSensorGroup()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateNxSensorType operation/method
 */
if ($update->UpdateNxSensorType(new \CustomerManagement\StructType\UpdateNxSensorType()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSensorVoiceDescriptors2Gig operation/method
 */
if ($update->UpdateSensorVoiceDescriptors2Gig(new \CustomerManagement\StructType\UpdateSensorVoiceDescriptors2Gig()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePanelCommunicationSetting operation/method
 */
if ($update->UpdatePanelCommunicationSetting(new \CustomerManagement\StructType\UpdatePanelCommunicationSetting()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateEnterpriseRoles operation/method
 */
if ($update->UpdateEnterpriseRoles(new \CustomerManagement\StructType\UpdateEnterpriseRoles()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateRoles operation/method
 */
if ($update->UpdateRoles(new \CustomerManagement\StructType\UpdateRoles()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerAddress operation/method
 */
if ($update->UpdateCustomerAddress(new \CustomerManagement\StructType\UpdateCustomerAddress()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerPassword operation/method
 */
if ($update->UpdateCustomerPassword(new \CustomerManagement\StructType\UpdateCustomerPassword()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerLogin operation/method
 */
if ($update->UpdateCustomerLogin(new \CustomerManagement\StructType\UpdateCustomerLogin()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerName operation/method
 */
if ($update->UpdateCustomerName(new \CustomerManagement\StructType\UpdateCustomerName()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAuthenticationProviderLoginName operation/method
 */
if ($update->UpdateAuthenticationProviderLoginName(new \CustomerManagement\StructType\UpdateAuthenticationProviderLoginName()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateLoginPassword operation/method
 */
if ($update->UpdateLoginPassword(new \CustomerManagement\StructType\UpdateLoginPassword()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateLoginPasswordWithoutPassword operation/method
 */
if ($update->UpdateLoginPasswordWithoutPassword(new \CustomerManagement\StructType\UpdateLoginPasswordWithoutPassword()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerBranch operation/method
 */
if ($update->UpdateCustomerBranch(new \CustomerManagement\StructType\UpdateCustomerBranch()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDealerCustomerId operation/method
 */
if ($update->UpdateDealerCustomerId(new \CustomerManagement\StructType\UpdateDealerCustomerId()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateInstallerSalesRep operation/method
 */
if ($update->UpdateInstallerSalesRep(new \CustomerManagement\StructType\UpdateInstallerSalesRep()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateEnrolledInMaintenance operation/method
 */
if ($update->UpdateEnrolledInMaintenance(new \CustomerManagement\StructType\UpdateEnrolledInMaintenance()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateInsuranceFeatures operation/method
 */
if ($update->UpdateInsuranceFeatures(new \CustomerManagement\StructType\UpdateInsuranceFeatures()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCentralStationInfo operation/method
 */
if ($update->UpdateCentralStationInfo(new \CustomerManagement\StructType\UpdateCentralStationInfo()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePrimaryEmail operation/method
 */
if ($update->UpdatePrimaryEmail(new \CustomerManagement\StructType\UpdatePrimaryEmail()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePrimaryPhone operation/method
 */
if ($update->UpdatePrimaryPhone(new \CustomerManagement\StructType\UpdatePrimaryPhone()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCameraSettings operation/method
 */
if ($update->UpdateCameraSettings(new \CustomerManagement\StructType\UpdateCameraSettings()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateNotifications operation/method
 */
if ($update->UpdateNotifications(new \CustomerManagement\StructType\UpdateNotifications()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerSecurityQuestion operation/method
 */
if ($update->UpdateCustomerSecurityQuestion(new \CustomerManagement\StructType\UpdateCustomerSecurityQuestion()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \CustomerManagement\ServiceType\Get($options);
$get->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for GetCustomerEnergyProgramEligibility operation/method
 */
if ($get->GetCustomerEnergyProgramEligibility(new \CustomerManagement\StructType\GetCustomerEnergyProgramEligibility()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetImageSensorLatestCaptureInfo operation/method
 */
if ($get->GetImageSensorLatestCaptureInfo(new \CustomerManagement\StructType\GetImageSensorLatestCaptureInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetImageSensorUploadsInfo operation/method
 */
if ($get->GetImageSensorUploadsInfo(new \CustomerManagement\StructType\GetImageSensorUploadsInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEligibleSensorGroups operation/method
 */
if ($get->GetEligibleSensorGroups(new \CustomerManagement\StructType\GetEligibleSensorGroups()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEligibleSensorNames operation/method
 */
if ($get->GetEligibleSensorNames(new \CustomerManagement\StructType\GetEligibleSensorNames()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserCodes operation/method
 */
if ($get->GetUserCodes(new \CustomerManagement\StructType\GetUserCodes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableWifiNetworks operation/method
 */
if ($get->GetAvailableWifiNetworks(new \CustomerManagement\StructType\GetAvailableWifiNetworks()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerBestPractices operation/method
 */
if ($get->GetCustomerBestPractices(new \CustomerManagement\StructType\GetCustomerBestPractices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCommunicationSetting operation/method
 */
if ($get->GetCommunicationSetting(new \CustomerManagement\StructType\GetCommunicationSetting()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDualPathCommunicationStatus operation/method
 */
if ($get->GetDualPathCommunicationStatus(new \CustomerManagement\StructType\GetDualPathCommunicationStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventHistory operation/method
 */
if ($get->GetEventHistory(new \CustomerManagement\StructType\GetEventHistory()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInstantaneousMode operation/method
 */
if ($get->GetInstantaneousMode(new \CustomerManagement\StructType\GetInstantaneousMode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPendingCommandInfo operation/method
 */
if ($get->GetPendingCommandInfo(new \CustomerManagement\StructType\GetPendingCommandInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLatestCallerVersion operation/method
 */
if ($get->GetLatestCallerVersion(new \CustomerManagement\StructType\GetLatestCallerVersion()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllCommitments operation/method
 */
if ($get->GetAllCommitments(new \CustomerManagement\StructType\GetAllCommitments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetScheduledAppointment operation/method
 */
if ($get->GetScheduledAppointment(new \CustomerManagement\StructType\GetScheduledAppointment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInteractiveLockoutStatus operation/method
 */
if ($get->GetInteractiveLockoutStatus(new \CustomerManagement\StructType\GetInteractiveLockoutStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReturnUrl operation/method
 */
if ($get->GetReturnUrl(new \CustomerManagement\StructType\GetReturnUrl()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSolarSystems operation/method
 */
if ($get->GetSolarSystems(new \CustomerManagement\StructType\GetSolarSystems()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSolarData operation/method
 */
if ($get->GetSolarData(new \CustomerManagement\StructType\GetSolarData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetElectricityProviders operation/method
 */
if ($get->GetElectricityProviders(new \CustomerManagement\StructType\GetElectricityProviders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetElectricityPlans operation/method
 */
if ($get->GetElectricityPlans(new \CustomerManagement\StructType\GetElectricityPlans()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeviceNotes operation/method
 */
if ($get->GetDeviceNotes(new \CustomerManagement\StructType\GetDeviceNotes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetModemSerialFromIccid operation/method
 */
if ($get->GetModemSerialFromIccid(new \CustomerManagement\StructType\GetModemSerialFromIccid()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSimStatusDuringActivation operation/method
 */
if ($get->GetSimStatusDuringActivation(new \CustomerManagement\StructType\GetSimStatusDuringActivation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastMessageDate operation/method
 */
if ($get->GetLastMessageDate(new \CustomerManagement\StructType\GetLastMessageDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastCsEventDate operation/method
 */
if ($get->GetLastCsEventDate(new \CustomerManagement\StructType\GetLastCsEventDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSignalStrengthSummary operation/method
 */
if ($get->GetSignalStrengthSummary(new \CustomerManagement\StructType\GetSignalStrengthSummary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSignalStrengthHistory operation/method
 */
if ($get->GetSignalStrengthHistory(new \CustomerManagement\StructType\GetSignalStrengthHistory()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeviceList operation/method
 */
if ($get->GetDeviceList(new \CustomerManagement\StructType\GetDeviceList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFullEquipmentList operation/method
 */
if ($get->GetFullEquipmentList(new \CustomerManagement\StructType\GetFullEquipmentList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerInfo operation/method
 */
if ($get->GetCustomerInfo(new \CustomerManagement\StructType\GetCustomerInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerInfo_V2 operation/method
 */
if ($get->GetCustomerInfo_V2(new \CustomerManagement\StructType\GetCustomerInfo_V2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerPrice operation/method
 */
if ($get->GetCustomerPrice(new \CustomerManagement\StructType\GetCustomerPrice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerTroubleConditions operation/method
 */
if ($get->GetCustomerTroubleConditions(new \CustomerManagement\StructType\GetCustomerTroubleConditions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerTroubleConditions_v2 operation/method
 */
if ($get->GetCustomerTroubleConditions_v2(new \CustomerManagement\StructType\GetCustomerTroubleConditions_v2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListWithTroubleConditions operation/method
 */
if ($get->GetCustomerListWithTroubleConditions(new \CustomerManagement\StructType\GetCustomerListWithTroubleConditions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListWithTroubleConditions_v2 operation/method
 */
if ($get->GetCustomerListWithTroubleConditions_v2(new \CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListWithTroubleConditionsCsv operation/method
 */
if ($get->GetCustomerListWithTroubleConditionsCsv(new \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListWithTroubleConditionsCsv_v2 operation/method
 */
if ($get->GetCustomerListWithTroubleConditionsCsv_v2(new \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetResolvedTroubleConditionsCsv operation/method
 */
if ($get->GetResolvedTroubleConditionsCsv(new \CustomerManagement\StructType\GetResolvedTroubleConditionsCsv()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListFor2G operation/method
 */
if ($get->GetCustomerListFor2G(new \CustomerManagement\StructType\GetCustomerListFor2G()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSystemCheckResults operation/method
 */
if ($get->GetSystemCheckResults(new \CustomerManagement\StructType\GetSystemCheckResults()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListWithPanelSetting operation/method
 */
if ($get->GetCustomerListWithPanelSetting(new \CustomerManagement\StructType\GetCustomerListWithPanelSetting()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerList operation/method
 */
if ($get->GetCustomerList(new \CustomerManagement\StructType\GetCustomerList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListByBranchId operation/method
 */
if ($get->GetCustomerListByBranchId(new \CustomerManagement\StructType\GetCustomerListByBranchId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListByEmail operation/method
 */
if ($get->GetCustomerListByEmail(new \CustomerManagement\StructType\GetCustomerListByEmail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerListByLoginName operation/method
 */
if ($get->GetCustomerListByLoginName(new \CustomerManagement\StructType\GetCustomerListByLoginName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDownloadableSettings operation/method
 */
if ($get->GetDownloadableSettings(new \CustomerManagement\StructType\GetDownloadableSettings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUploadedPanelSettings operation/method
 */
if ($get->GetUploadedPanelSettings(new \CustomerManagement\StructType\GetUploadedPanelSettings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetImageSensorInfo operation/method
 */
if ($get->GetImageSensorInfo(new \CustomerManagement\StructType\GetImageSensorInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPauseNotificationsForCustomer operation/method
 */
if ($get->GetPauseNotificationsForCustomer(new \CustomerManagement\StructType\GetPauseNotificationsForCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSecurityQuestions operation/method
 */
if ($get->GetSecurityQuestions(new \CustomerManagement\StructType\GetSecurityQuestions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllLogins operation/method
 */
if ($get->GetAllLogins(new \CustomerManagement\StructType\GetAllLogins()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Hard ServiceType
 */
$hard = new \CustomerManagement\ServiceType\Hard($options);
$hard->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for HardResetModule operation/method
 */
if ($hard->HardResetModule(new \CustomerManagement\StructType\HardResetModule()) !== false) {
    print_r($hard->getResult());
} else {
    print_r($hard->getLastError());
}
/**
 * Sample call for HardResetModuleQolsys operation/method
 */
if ($hard->HardResetModuleQolsys(new \CustomerManagement\StructType\HardResetModuleQolsys()) !== false) {
    print_r($hard->getResult());
} else {
    print_r($hard->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \CustomerManagement\ServiceType\Test($options);
$test->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for TestVideoDeviceConnectivity operation/method
 */
if ($test->TestVideoDeviceConnectivity(new \CustomerManagement\StructType\TestVideoDeviceConnectivity()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \CustomerManagement\ServiceType\Set($options);
$set->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for SetImageSensorSettings operation/method
 */
if ($set->SetImageSensorSettings(new \CustomerManagement\StructType\SetImageSensorSettings()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAutoPhoneTestSettings operation/method
 */
if ($set->SetAutoPhoneTestSettings(new \CustomerManagement\StructType\SetAutoPhoneTestSettings()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetWifi operation/method
 */
if ($set->SetWifi(new \CustomerManagement\StructType\SetWifi()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetGsmBandSelection operation/method
 */
if ($set->SetGsmBandSelection(new \CustomerManagement\StructType\SetGsmBandSelection()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetAddOnQuantity operation/method
 */
if ($set->SetAddOnQuantity(new \CustomerManagement\StructType\SetAddOnQuantity()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetImageSensorPartition operation/method
 */
if ($set->SetImageSensorPartition(new \CustomerManagement\StructType\SetImageSensorPartition()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPauseNotificationsForCustomer operation/method
 */
if ($set->SetPauseNotificationsForCustomer(new \CustomerManagement\StructType\SetPauseNotificationsForCustomer()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Backup ServiceType
 */
$backup = new \CustomerManagement\ServiceType\Backup($options);
$backup->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for BackupPanelSettings operation/method
 */
if ($backup->BackupPanelSettings(new \CustomerManagement\StructType\BackupPanelSettings()) !== false) {
    print_r($backup->getResult());
} else {
    print_r($backup->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \CustomerManagement\ServiceType\Check($options);
$check->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for CheckPanelSettingsBackup operation/method
 */
if ($check->CheckPanelSettingsBackup(new \CustomerManagement\StructType\CheckPanelSettingsBackup()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckAvailableLoginName operation/method
 */
if ($check->CheckAvailableLoginName(new \CustomerManagement\StructType\CheckAvailableLoginName()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Restore ServiceType
 */
$restore = new \CustomerManagement\ServiceType\Restore($options);
$restore->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for RestoreBackedUpPanelSettings operation/method
 */
if ($restore->RestoreBackedUpPanelSettings(new \CustomerManagement\StructType\RestoreBackedUpPanelSettings()) !== false) {
    print_r($restore->getResult());
} else {
    print_r($restore->getLastError());
}
/**
 * Samples for Edit ServiceType
 */
$edit = new \CustomerManagement\ServiceType\Edit($options);
$edit->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for EditMasterCode operation/method
 */
if ($edit->EditMasterCode(new \CustomerManagement\StructType\EditMasterCode()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditUserCode operation/method
 */
if ($edit->EditUserCode(new \CustomerManagement\StructType\EditUserCode()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Sample call for EditScheduledAppointment operation/method
 */
if ($edit->EditScheduledAppointment(new \CustomerManagement\StructType\EditScheduledAppointment()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Samples for Request ServiceType
 */
$request = new \CustomerManagement\ServiceType\Request($options);
$request->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for RequestUpdatedEquipmentList operation/method
 */
if ($request->RequestUpdatedEquipmentList(new \CustomerManagement\StructType\RequestUpdatedEquipmentList()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestAvailableWifiNetworkNames operation/method
 */
if ($request->RequestAvailableWifiNetworkNames(new \CustomerManagement\StructType\RequestAvailableWifiNetworkNames()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestRoundTripCsTest operation/method
 */
if ($request->RequestRoundTripCsTest(new \CustomerManagement\StructType\RequestRoundTripCsTest()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestSignalStrength operation/method
 */
if ($request->RequestSignalStrength(new \CustomerManagement\StructType\RequestSignalStrength()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestFirmwareVersionCommand operation/method
 */
if ($request->RequestFirmwareVersionCommand(new \CustomerManagement\StructType\RequestFirmwareVersionCommand()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestSensorNames operation/method
 */
if ($request->RequestSensorNames(new \CustomerManagement\StructType\RequestSensorNames()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestUploadOfPanelSettings operation/method
 */
if ($request->RequestUploadOfPanelSettings(new \CustomerManagement\StructType\RequestUploadOfPanelSettings()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestZWaveEquipmentList operation/method
 */
if ($request->RequestZWaveEquipmentList(new \CustomerManagement\StructType\RequestZWaveEquipmentList()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestFirmwareUpgradeQolsys operation/method
 */
if ($request->RequestFirmwareUpgradeQolsys(new \CustomerManagement\StructType\RequestFirmwareUpgradeQolsys()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestFirmwareUpgrade operation/method
 */
if ($request->RequestFirmwareUpgrade(new \CustomerManagement\StructType\RequestFirmwareUpgrade()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Samples for Activate ServiceType
 */
$activate = new \CustomerManagement\ServiceType\Activate($options);
$activate->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for ActivateInstantaneousMode operation/method
 */
if ($activate->ActivateInstantaneousMode(new \CustomerManagement\StructType\ActivateInstantaneousMode()) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Sample call for ActivateModem operation/method
 */
if ($activate->ActivateModem(new \CustomerManagement\StructType\ActivateModem()) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Sample call for ActivateCommitment operation/method
 */
if ($activate->ActivateCommitment(new \CustomerManagement\StructType\ActivateCommitment()) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \CustomerManagement\ServiceType\End($options);
$end->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for EndInstantaneousMode operation/method
 */
if ($end->EndInstantaneousMode(new \CustomerManagement\StructType\EndInstantaneousMode()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Enable ServiceType
 */
$enable = new \CustomerManagement\ServiceType\Enable($options);
$enable->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for EnableInteractiveLockout operation/method
 */
if ($enable->EnableInteractiveLockout(new \CustomerManagement\StructType\EnableInteractiveLockout()) !== false) {
    print_r($enable->getResult());
} else {
    print_r($enable->getLastError());
}
/**
 * Samples for Disable ServiceType
 */
$disable = new \CustomerManagement\ServiceType\Disable($options);
$disable->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for DisableInteractiveLockout operation/method
 */
if ($disable->DisableInteractiveLockout(new \CustomerManagement\StructType\DisableInteractiveLockout()) !== false) {
    print_r($disable->getResult());
} else {
    print_r($disable->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \CustomerManagement\ServiceType\Save($options);
$save->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for SaveUtilityInfo operation/method
 */
if ($save->SaveUtilityInfo(new \CustomerManagement\StructType\SaveUtilityInfo()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \CustomerManagement\ServiceType\Is($options);
$is->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for IsModemActivated operation/method
 */
if ($is->IsModemActivated(new \CustomerManagement\StructType\IsModemActivated()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Terminate ServiceType
 */
$terminate = new \CustomerManagement\ServiceType\Terminate($options);
$terminate->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for TerminateModem operation/method
 */
if ($terminate->TerminateModem(new \CustomerManagement\StructType\TerminateModem()) !== false) {
    print_r($terminate->getResult());
} else {
    print_r($terminate->getLastError());
}
/**
 * Sample call for TerminateModem_v2 operation/method
 */
if ($terminate->TerminateModem_v2(new \CustomerManagement\StructType\TerminateModem_v2()) !== false) {
    print_r($terminate->getResult());
} else {
    print_r($terminate->getLastError());
}
/**
 * Sample call for TerminateCustomer operation/method
 */
if ($terminate->TerminateCustomer(new \CustomerManagement\StructType\TerminateCustomer()) !== false) {
    print_r($terminate->getResult());
} else {
    print_r($terminate->getLastError());
}
/**
 * Samples for Apply ServiceType
 */
$apply = new \CustomerManagement\ServiceType\Apply($options);
$apply->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for ApplyPanelTemplate operation/method
 */
if ($apply->ApplyPanelTemplate(new \CustomerManagement\StructType\ApplyPanelTemplate()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Samples for Email ServiceType
 */
$email = new \CustomerManagement\ServiceType\Email($options);
$email->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for EmailWelcomeLetter operation/method
 */
if ($email->EmailWelcomeLetter(new \CustomerManagement\StructType\EmailWelcomeLetter()) !== false) {
    print_r($email->getResult());
} else {
    print_r($email->getLastError());
}
/**
 * Samples for Swap ServiceType
 */
$swap = new \CustomerManagement\ServiceType\Swap($options);
$swap->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for SwapModem operation/method
 */
if ($swap->SwapModem(new \CustomerManagement\StructType\SwapModem()) !== false) {
    print_r($swap->getResult());
} else {
    print_r($swap->getLastError());
}
/**
 * Samples for Emulate ServiceType
 */
$emulate = new \CustomerManagement\ServiceType\Emulate($options);
$emulate->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for EmulateTransferAccounts operation/method
 */
if ($emulate->EmulateTransferAccounts(new \CustomerManagement\StructType\EmulateTransferAccounts()) !== false) {
    print_r($emulate->getResult());
} else {
    print_r($emulate->getLastError());
}
/**
 * Samples for Transfer ServiceType
 */
$transfer = new \CustomerManagement\ServiceType\Transfer($options);
$transfer->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for TransferAccounts operation/method
 */
if ($transfer->TransferAccounts(new \CustomerManagement\StructType\TransferAccounts()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Samples for Lookup ServiceType
 */
$lookup = new \CustomerManagement\ServiceType\Lookup($options);
$lookup->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for LookupCustomerId operation/method
 */
if ($lookup->LookupCustomerId(new \CustomerManagement\StructType\LookupCustomerId()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Sample call for LookupCustomerIdForDealer operation/method
 */
if ($lookup->LookupCustomerIdForDealer(new \CustomerManagement\StructType\LookupCustomerIdForDealer()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Sample call for LookupCustomerIdFromDealerCustomerId operation/method
 */
if ($lookup->LookupCustomerIdFromDealerCustomerId(new \CustomerManagement\StructType\LookupCustomerIdFromDealerCustomerId()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Sample call for LookupCustomerIdFromModemSerial operation/method
 */
if ($lookup->LookupCustomerIdFromModemSerial(new \CustomerManagement\StructType\LookupCustomerIdFromModemSerial()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Samples for Run ServiceType
 */
$run = new \CustomerManagement\ServiceType\Run($options);
$run->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for RunSystemCheck operation/method
 */
if ($run->RunSystemCheck(new \CustomerManagement\StructType\RunSystemCheck()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \CustomerManagement\ServiceType\Generate($options);
$generate->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for GenerateCustomerLoginToken operation/method
 */
if ($generate->GenerateCustomerLoginToken(new \CustomerManagement\StructType\GenerateCustomerLoginToken()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLoginToken operation/method
 */
if ($generate->GenerateLoginToken(new \CustomerManagement\StructType\GenerateLoginToken()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateLoginToken_v2 operation/method
 */
if ($generate->GenerateLoginToken_v2(new \CustomerManagement\StructType\GenerateLoginToken_v2()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \CustomerManagement\ServiceType\Validate($options);
$validate->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for ValidateLoginPassword operation/method
 */
if ($validate->ValidateLoginPassword(new \CustomerManagement\StructType\ValidateLoginPassword()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateLoginPassword_v2 operation/method
 */
if ($validate->ValidateLoginPassword_v2(new \CustomerManagement\StructType\ValidateLoginPassword_v2()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Invalidate ServiceType
 */
$invalidate = new \CustomerManagement\ServiceType\Invalidate($options);
$invalidate->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for InvalidateLoginTokens_v2 operation/method
 */
if ($invalidate->InvalidateLoginTokens_v2(new \CustomerManagement\StructType\InvalidateLoginTokens_v2()) !== false) {
    print_r($invalidate->getResult());
} else {
    print_r($invalidate->getLastError());
}
/**
 * Sample call for InvalidateLoginTokens operation/method
 */
if ($invalidate->InvalidateLoginTokens(new \CustomerManagement\StructType\InvalidateLoginTokens()) !== false) {
    print_r($invalidate->getResult());
} else {
    print_r($invalidate->getLastError());
}
/**
 * Samples for Has ServiceType
 */
$has = new \CustomerManagement\ServiceType\Has($options);
$has->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for HasInsuranceFeatures operation/method
 */
if ($has->HasInsuranceFeatures(new \CustomerManagement\StructType\HasInsuranceFeatures()) !== false) {
    print_r($has->getResult());
} else {
    print_r($has->getLastError());
}
/**
 * Samples for Service ServiceType
 */
$service = new \CustomerManagement\ServiceType\Service($options);
$service->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for ServicePlanAudit operation/method
 */
if ($service->ServicePlanAudit(new \CustomerManagement\StructType\ServicePlanAudit()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Samples for Downgrade ServiceType
 */
$downgrade = new \CustomerManagement\ServiceType\Downgrade($options);
$downgrade->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for DowngradeSecurityToSAVAccount operation/method
 */
if ($downgrade->DowngradeSecurityToSAVAccount(new \CustomerManagement\StructType\DowngradeSecurityToSAVAccount()) !== false) {
    print_r($downgrade->getResult());
} else {
    print_r($downgrade->getLastError());
}
/**
 * Samples for Upgrade ServiceType
 */
$upgrade = new \CustomerManagement\ServiceType\Upgrade($options);
$upgrade->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for UpgradeSAVToSecurityAccount operation/method
 */
if ($upgrade->UpgradeSAVToSecurityAccount(new \CustomerManagement\StructType\UpgradeSAVToSecurityAccount()) !== false) {
    print_r($upgrade->getResult());
} else {
    print_r($upgrade->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \CustomerManagement\ServiceType\Change($options);
$change->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for ChangeServicePlan operation/method
 */
if ($change->ChangeServicePlan(new \CustomerManagement\StructType\ChangeServicePlan()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeServicePlanTemplate operation/method
 */
if ($change->ChangeServicePlanTemplate(new \CustomerManagement\StructType\ChangeServicePlanTemplate()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Confirm ServiceType
 */
$confirm = new \CustomerManagement\ServiceType\Confirm($options);
$confirm->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for ConfirmPrimaryEmail operation/method
 */
if ($confirm->ConfirmPrimaryEmail(new \CustomerManagement\StructType\ConfirmPrimaryEmail()) !== false) {
    print_r($confirm->getResult());
} else {
    print_r($confirm->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \CustomerManagement\ServiceType\Send($options);
$send->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for SendEnterpriseNotice operation/method
 */
if ($send->SendEnterpriseNotice(new \CustomerManagement\StructType\SendEnterpriseNotice()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Download ServiceType
 */
$download = new \CustomerManagement\ServiceType\Download($options);
$download->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for DownloadToPanel operation/method
 */
if ($download->DownloadToPanel(new \CustomerManagement\StructType\DownloadToPanel()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Samples for Turn ServiceType
 */
$turn = new \CustomerManagement\ServiceType\Turn($options);
$turn->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for TurnOffAccessCodeLock operation/method
 */
if ($turn->TurnOffAccessCodeLock(new \CustomerManagement\StructType\TurnOffAccessCodeLock()) !== false) {
    print_r($turn->getResult());
} else {
    print_r($turn->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \CustomerManagement\ServiceType\Remove($options);
$remove->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for RemoveNotification operation/method
 */
if ($remove->RemoveNotification(new \CustomerManagement\StructType\RemoveNotification()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Merge ServiceType
 */
$merge = new \CustomerManagement\ServiceType\Merge($options);
$merge->setSoapHeaderAuthentication(new \CustomerManagement\StructType\Authentication_1());
/**
 * Sample call for MergeLogins operation/method
 */
if ($merge->MergeLogins(new \CustomerManagement\StructType\MergeLogins()) !== false) {
    print_r($merge->getResult());
} else {
    print_r($merge->getLastError());
}
/**
 * Sample call for MergeLoginsByLoginName operation/method
 */
if ($merge->MergeLoginsByLoginName(new \CustomerManagement\StructType\MergeLoginsByLoginName()) !== false) {
    print_r($merge->getResult());
} else {
    print_r($merge->getLastError());
}
