<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventTypeEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventTypeEnum extends AbstractStructArrayBase
{
    /**
     * The EventTypeEnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $EventTypeEnum;
    /**
     * Constructor method for ArrayOfEventTypeEnum
     * @uses ArrayOfEventTypeEnum::setEventTypeEnum()
     * @param string[] $eventTypeEnum
     */
    public function __construct(array $eventTypeEnum = array())
    {
        $this
            ->setEventTypeEnum($eventTypeEnum);
    }
    /**
     * Get EventTypeEnum value
     * @return string[]|null
     */
    public function getEventTypeEnum()
    {
        return $this->EventTypeEnum;
    }
    /**
     * Set EventTypeEnum value
     * @uses \CustomerManagement\EnumType\EventTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\EventTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $eventTypeEnum
     * @return \CustomerManagement\ArrayType\ArrayOfEventTypeEnum
     */
    public function setEventTypeEnum(array $eventTypeEnum = array())
    {
        $invalidValues = array();
        foreach ($eventTypeEnum as $arrayOfEventTypeEnumEventTypeEnumItem) {
            if (!\CustomerManagement\EnumType\EventTypeEnum::valueIsValid($arrayOfEventTypeEnumEventTypeEnumItem)) {
                $invalidValues[] = var_export($arrayOfEventTypeEnumEventTypeEnumItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \CustomerManagement\EnumType\EventTypeEnum::getValidValues())), __LINE__);
        }
        $this->EventTypeEnum = $eventTypeEnum;
        return $this;
    }
    /**
     * Add item to EventTypeEnum value
     * @uses \CustomerManagement\EnumType\EventTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\EventTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfEventTypeEnum
     */
    public function addToEventTypeEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\EventTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\EventTypeEnum::getValidValues())), __LINE__);
        }
        $this->EventTypeEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\EventTypeEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfEventTypeEnum
     */
    public function add($item)
    {
        if (!\CustomerManagement\EnumType\EventTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\EventTypeEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventTypeEnum
     */
    public function getAttributeName()
    {
        return 'EventTypeEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfEventTypeEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
