<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInstallerSalesRepInput StructType
 * @subpackage Structs
 */
class UpdateInstallerSalesRepInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SalesRepId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SalesRepId;
    /**
     * The InstallerRepId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $InstallerRepId;
    /**
     * Constructor method for UpdateInstallerSalesRepInput
     * @uses UpdateInstallerSalesRepInput::setCustomerId()
     * @uses UpdateInstallerSalesRepInput::setSalesRepId()
     * @uses UpdateInstallerSalesRepInput::setInstallerRepId()
     * @param int $customerId
     * @param int $salesRepId
     * @param int $installerRepId
     */
    public function __construct($customerId = null, $salesRepId = null, $installerRepId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSalesRepId($salesRepId)
            ->setInstallerRepId($installerRepId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateInstallerSalesRepInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SalesRepId value
     * @return int
     */
    public function getSalesRepId()
    {
        return $this->SalesRepId;
    }
    /**
     * Set SalesRepId value
     * @param int $salesRepId
     * @return \CustomerManagement\StructType\UpdateInstallerSalesRepInput
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: int
        if (!is_null($salesRepId) && !is_numeric($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesRepId)), __LINE__);
        }
        $this->SalesRepId = $salesRepId;
        return $this;
    }
    /**
     * Get InstallerRepId value
     * @return int
     */
    public function getInstallerRepId()
    {
        return $this->InstallerRepId;
    }
    /**
     * Set InstallerRepId value
     * @param int $installerRepId
     * @return \CustomerManagement\StructType\UpdateInstallerSalesRepInput
     */
    public function setInstallerRepId($installerRepId = null)
    {
        // validation for constraint: int
        if (!is_null($installerRepId) && !is_numeric($installerRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($installerRepId)), __LINE__);
        }
        $this->InstallerRepId = $installerRepId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateInstallerSalesRepInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
