<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for GsmTowerFrequencyEnum EnumType
 * @subpackage Enumerations
 */
class GsmTowerFrequencyEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'f850900MHz'
     * @return string 'f850900MHz'
     */
    const VALUE_F_850900_MHZ = 'f850900MHz';
    /**
     * Constant for value 'f19001800MHz'
     * @return string 'f19001800MHz'
     */
    const VALUE_F_19001800_MHZ = 'f19001800MHz';
    /**
     * Constant for value 'f850_3G'
     * @return string 'f850_3G'
     */
    const VALUE_F_850_3_G = 'f850_3G';
    /**
     * Constant for value 'f1900_3G'
     * @return string 'f1900_3G'
     */
    const VALUE_F_1900_3_G = 'f1900_3G';
    /**
     * Constant for value 'fAws'
     * @return string 'fAws'
     */
    const VALUE_F_AWS = 'fAws';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_F_850900_MHZ
     * @uses self::VALUE_F_19001800_MHZ
     * @uses self::VALUE_F_850_3_G
     * @uses self::VALUE_F_1900_3_G
     * @uses self::VALUE_F_AWS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_F_850900_MHZ,
            self::VALUE_F_19001800_MHZ,
            self::VALUE_F_850_3_G,
            self::VALUE_F_1900_3_G,
            self::VALUE_F_AWS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
