<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeServicePlanTemplate StructType
 * @subpackage Structs
 */
class ChangeServicePlanTemplate extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The customPackageTemplateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customPackageTemplateId;
    /**
     * Constructor method for ChangeServicePlanTemplate
     * @uses ChangeServicePlanTemplate::setCustomerId()
     * @uses ChangeServicePlanTemplate::setCustomPackageTemplateId()
     * @param int $customerId
     * @param int $customPackageTemplateId
     */
    public function __construct($customerId = null, $customPackageTemplateId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCustomPackageTemplateId($customPackageTemplateId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ChangeServicePlanTemplate
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get customPackageTemplateId value
     * @return int
     */
    public function getCustomPackageTemplateId()
    {
        return $this->customPackageTemplateId;
    }
    /**
     * Set customPackageTemplateId value
     * @param int $customPackageTemplateId
     * @return \CustomerManagement\StructType\ChangeServicePlanTemplate
     */
    public function setCustomPackageTemplateId($customPackageTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($customPackageTemplateId) && !is_numeric($customPackageTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customPackageTemplateId)), __LINE__);
        }
        $this->customPackageTemplateId = $customPackageTemplateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ChangeServicePlanTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
