<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInsuranceFeaturesInput StructType
 * @subpackage Structs
 */
class UpdateInsuranceFeaturesInput extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The EnableInsuranceFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableInsuranceFeatures;
    /**
     * Constructor method for UpdateInsuranceFeaturesInput
     * @uses UpdateInsuranceFeaturesInput::setCustomerID()
     * @uses UpdateInsuranceFeaturesInput::setEnableInsuranceFeatures()
     * @param int $customerID
     * @param bool $enableInsuranceFeatures
     */
    public function __construct($customerID = null, $enableInsuranceFeatures = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setEnableInsuranceFeatures($enableInsuranceFeatures);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \CustomerManagement\StructType\UpdateInsuranceFeaturesInput
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get EnableInsuranceFeatures value
     * @return bool
     */
    public function getEnableInsuranceFeatures()
    {
        return $this->EnableInsuranceFeatures;
    }
    /**
     * Set EnableInsuranceFeatures value
     * @param bool $enableInsuranceFeatures
     * @return \CustomerManagement\StructType\UpdateInsuranceFeaturesInput
     */
    public function setEnableInsuranceFeatures($enableInsuranceFeatures = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableInsuranceFeatures) && !is_bool($enableInsuranceFeatures)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enableInsuranceFeatures)), __LINE__);
        }
        $this->EnableInsuranceFeatures = $enableInsuranceFeatures;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateInsuranceFeaturesInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
