<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerEnergyProgramEligibilityRow StructType
 * @subpackage Structs
 */
class GetCustomerEnergyProgramEligibilityRow extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The EnergyProgramId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EnergyProgramId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StatusChangeDateUtc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StatusChangeDateUtc;
    /**
     * The DealerCustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DealerCustomerId;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for GetCustomerEnergyProgramEligibilityRow
     * @uses GetCustomerEnergyProgramEligibilityRow::setCustomerId()
     * @uses GetCustomerEnergyProgramEligibilityRow::setEnergyProgramId()
     * @uses GetCustomerEnergyProgramEligibilityRow::setStatus()
     * @uses GetCustomerEnergyProgramEligibilityRow::setStatusChangeDateUtc()
     * @uses GetCustomerEnergyProgramEligibilityRow::setDealerCustomerId()
     * @uses GetCustomerEnergyProgramEligibilityRow::setFirstName()
     * @uses GetCustomerEnergyProgramEligibilityRow::setLastName()
     * @uses GetCustomerEnergyProgramEligibilityRow::setEmailAddress()
     * @uses GetCustomerEnergyProgramEligibilityRow::setPhoneNumber()
     * @param int $customerId
     * @param int $energyProgramId
     * @param string $status
     * @param string $statusChangeDateUtc
     * @param string $dealerCustomerId
     * @param string $firstName
     * @param string $lastName
     * @param string $emailAddress
     * @param string $phoneNumber
     */
    public function __construct($customerId = null, $energyProgramId = null, $status = null, $statusChangeDateUtc = null, $dealerCustomerId = null, $firstName = null, $lastName = null, $emailAddress = null, $phoneNumber = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setEnergyProgramId($energyProgramId)
            ->setStatus($status)
            ->setStatusChangeDateUtc($statusChangeDateUtc)
            ->setDealerCustomerId($dealerCustomerId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmailAddress($emailAddress)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get EnergyProgramId value
     * @return int
     */
    public function getEnergyProgramId()
    {
        return $this->EnergyProgramId;
    }
    /**
     * Set EnergyProgramId value
     * @param int $energyProgramId
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setEnergyProgramId($energyProgramId = null)
    {
        // validation for constraint: int
        if (!is_null($energyProgramId) && !is_numeric($energyProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($energyProgramId)), __LINE__);
        }
        $this->EnergyProgramId = $energyProgramId;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\ProgramEnrollmentStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\ProgramEnrollmentStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ProgramEnrollmentStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \CustomerManagement\EnumType\ProgramEnrollmentStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusChangeDateUtc value
     * @return string
     */
    public function getStatusChangeDateUtc()
    {
        return $this->StatusChangeDateUtc;
    }
    /**
     * Set StatusChangeDateUtc value
     * @param string $statusChangeDateUtc
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setStatusChangeDateUtc($statusChangeDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($statusChangeDateUtc) && !is_string($statusChangeDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusChangeDateUtc)), __LINE__);
        }
        $this->StatusChangeDateUtc = $statusChangeDateUtc;
        return $this;
    }
    /**
     * Get DealerCustomerId value
     * @return string|null
     */
    public function getDealerCustomerId()
    {
        return $this->DealerCustomerId;
    }
    /**
     * Set DealerCustomerId value
     * @param string $dealerCustomerId
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setDealerCustomerId($dealerCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerCustomerId) && !is_string($dealerCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerCustomerId)), __LINE__);
        }
        $this->DealerCustomerId = $dealerCustomerId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityRow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
