<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DualPathCommunicationSettingEnum EnumType
 * @subpackage Enumerations
 */
class DualPathCommunicationSettingEnum
{
    /**
     * Constant for value 'Cell'
     * @return string 'Cell'
     */
    const VALUE_CELL = 'Cell';
    /**
     * Constant for value 'CellAndBroadband'
     * @return string 'CellAndBroadband'
     */
    const VALUE_CELL_AND_BROADBAND = 'CellAndBroadband';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CELL
     * @uses self::VALUE_CELL_AND_BROADBAND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CELL,
            self::VALUE_CELL_AND_BROADBAND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
