<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveUtilityInfoInput StructType
 * @subpackage Structs
 */
class SaveUtilityInfoInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The LseId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LseId;
    /**
     * The MasterTariffId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MasterTariffId;
    /**
     * The BillDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillDay;
    /**
     * The BillEst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillEst;
    /**
     * Constructor method for SaveUtilityInfoInput
     * @uses SaveUtilityInfoInput::setCustomerId()
     * @uses SaveUtilityInfoInput::setLseId()
     * @uses SaveUtilityInfoInput::setMasterTariffId()
     * @uses SaveUtilityInfoInput::setBillDay()
     * @uses SaveUtilityInfoInput::setBillEst()
     * @param int $customerId
     * @param int $lseId
     * @param int $masterTariffId
     * @param string $billDay
     * @param int $billEst
     */
    public function __construct($customerId = null, $lseId = null, $masterTariffId = null, $billDay = null, $billEst = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLseId($lseId)
            ->setMasterTariffId($masterTariffId)
            ->setBillDay($billDay)
            ->setBillEst($billEst);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SaveUtilityInfoInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get LseId value
     * @return int
     */
    public function getLseId()
    {
        return $this->LseId;
    }
    /**
     * Set LseId value
     * @param int $lseId
     * @return \CustomerManagement\StructType\SaveUtilityInfoInput
     */
    public function setLseId($lseId = null)
    {
        // validation for constraint: int
        if (!is_null($lseId) && !is_numeric($lseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lseId)), __LINE__);
        }
        $this->LseId = $lseId;
        return $this;
    }
    /**
     * Get MasterTariffId value
     * @return int
     */
    public function getMasterTariffId()
    {
        return $this->MasterTariffId;
    }
    /**
     * Set MasterTariffId value
     * @param int $masterTariffId
     * @return \CustomerManagement\StructType\SaveUtilityInfoInput
     */
    public function setMasterTariffId($masterTariffId = null)
    {
        // validation for constraint: int
        if (!is_null($masterTariffId) && !is_numeric($masterTariffId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($masterTariffId)), __LINE__);
        }
        $this->MasterTariffId = $masterTariffId;
        return $this;
    }
    /**
     * Get BillDay value
     * @return string
     */
    public function getBillDay()
    {
        return $this->BillDay;
    }
    /**
     * Set BillDay value
     * @param string $billDay
     * @return \CustomerManagement\StructType\SaveUtilityInfoInput
     */
    public function setBillDay($billDay = null)
    {
        // validation for constraint: string
        if (!is_null($billDay) && !is_string($billDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDay)), __LINE__);
        }
        $this->BillDay = $billDay;
        return $this;
    }
    /**
     * Get BillEst value
     * @return int
     */
    public function getBillEst()
    {
        return $this->BillEst;
    }
    /**
     * Set BillEst value
     * @param int $billEst
     * @return \CustomerManagement\StructType\SaveUtilityInfoInput
     */
    public function setBillEst($billEst = null)
    {
        // validation for constraint: int
        if (!is_null($billEst) && !is_numeric($billEst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billEst)), __LINE__);
        }
        $this->BillEst = $billEst;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SaveUtilityInfoInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
