<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPasswordQuestion ArrayType
 * @subpackage Arrays
 */
class ArrayOfPasswordQuestion extends AbstractStructArrayBase
{
    /**
     * The PasswordQuestion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\PasswordQuestion[]
     */
    public $PasswordQuestion;
    /**
     * Constructor method for ArrayOfPasswordQuestion
     * @uses ArrayOfPasswordQuestion::setPasswordQuestion()
     * @param \CustomerManagement\StructType\PasswordQuestion[] $passwordQuestion
     */
    public function __construct(array $passwordQuestion = array())
    {
        $this
            ->setPasswordQuestion($passwordQuestion);
    }
    /**
     * Get PasswordQuestion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\PasswordQuestion[]|null
     */
    public function getPasswordQuestion()
    {
        return isset($this->PasswordQuestion) ? $this->PasswordQuestion : null;
    }
    /**
     * Set PasswordQuestion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\PasswordQuestion[] $passwordQuestion
     * @return \CustomerManagement\ArrayType\ArrayOfPasswordQuestion
     */
    public function setPasswordQuestion(array $passwordQuestion = array())
    {
        foreach ($passwordQuestion as $arrayOfPasswordQuestionPasswordQuestionItem) {
            // validation for constraint: itemType
            if (!$arrayOfPasswordQuestionPasswordQuestionItem instanceof \CustomerManagement\StructType\PasswordQuestion) {
                throw new \InvalidArgumentException(sprintf('The PasswordQuestion property can only contain items of \CustomerManagement\StructType\PasswordQuestion, "%s" given', is_object($arrayOfPasswordQuestionPasswordQuestionItem) ? get_class($arrayOfPasswordQuestionPasswordQuestionItem) : gettype($arrayOfPasswordQuestionPasswordQuestionItem)), __LINE__);
            }
        }
        if (is_null($passwordQuestion) || (is_array($passwordQuestion) && empty($passwordQuestion))) {
            unset($this->PasswordQuestion);
        } else {
            $this->PasswordQuestion = $passwordQuestion;
        }
        return $this;
    }
    /**
     * Add item to PasswordQuestion value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\PasswordQuestion $item
     * @return \CustomerManagement\ArrayType\ArrayOfPasswordQuestion
     */
    public function addToPasswordQuestion(\CustomerManagement\StructType\PasswordQuestion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\PasswordQuestion) {
            throw new \InvalidArgumentException(sprintf('The PasswordQuestion property can only contain items of \CustomerManagement\StructType\PasswordQuestion, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PasswordQuestion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\PasswordQuestion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\PasswordQuestion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\PasswordQuestion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\PasswordQuestion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\PasswordQuestion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PasswordQuestion
     */
    public function getAttributeName()
    {
        return 'PasswordQuestion';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfPasswordQuestion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
