<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddOnFeatureEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfAddOnFeatureEnum extends AbstractStructArrayBase
{
    /**
     * The AddOnFeatureEnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AddOnFeatureEnum;
    /**
     * Constructor method for ArrayOfAddOnFeatureEnum
     * @uses ArrayOfAddOnFeatureEnum::setAddOnFeatureEnum()
     * @param string[] $addOnFeatureEnum
     */
    public function __construct(array $addOnFeatureEnum = array())
    {
        $this
            ->setAddOnFeatureEnum($addOnFeatureEnum);
    }
    /**
     * Get AddOnFeatureEnum value
     * @return string[]|null
     */
    public function getAddOnFeatureEnum()
    {
        return $this->AddOnFeatureEnum;
    }
    /**
     * Set AddOnFeatureEnum value
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $addOnFeatureEnum
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public function setAddOnFeatureEnum(array $addOnFeatureEnum = array())
    {
        $invalidValues = array();
        foreach ($addOnFeatureEnum as $arrayOfAddOnFeatureEnumAddOnFeatureEnumItem) {
            if (!\CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid($arrayOfAddOnFeatureEnumAddOnFeatureEnumItem)) {
                $invalidValues[] = var_export($arrayOfAddOnFeatureEnumAddOnFeatureEnumItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues())), __LINE__);
        }
        $this->AddOnFeatureEnum = $addOnFeatureEnum;
        return $this;
    }
    /**
     * Add item to AddOnFeatureEnum value
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public function addToAddOnFeatureEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues())), __LINE__);
        }
        $this->AddOnFeatureEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public function add($item)
    {
        if (!\CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddOnFeatureEnum
     */
    public function getAttributeName()
    {
        return 'AddOnFeatureEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
