<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WiFiNetworkInfo StructType
 * @subpackage Structs
 */
class WiFiNetworkInfo extends AbstractStructBase
{
    /**
     * The EncryptionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EncryptionType;
    /**
     * The HasPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasPassword;
    /**
     * The LastReported
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastReported;
    /**
     * The WiFiNetworkName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WiFiNetworkName;
    /**
     * The SignalStrength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SignalStrength;
    /**
     * Constructor method for WiFiNetworkInfo
     * @uses WiFiNetworkInfo::setEncryptionType()
     * @uses WiFiNetworkInfo::setHasPassword()
     * @uses WiFiNetworkInfo::setLastReported()
     * @uses WiFiNetworkInfo::setWiFiNetworkName()
     * @uses WiFiNetworkInfo::setSignalStrength()
     * @param string $encryptionType
     * @param bool $hasPassword
     * @param string $lastReported
     * @param string $wiFiNetworkName
     * @param string $signalStrength
     */
    public function __construct($encryptionType = null, $hasPassword = null, $lastReported = null, $wiFiNetworkName = null, $signalStrength = null)
    {
        $this
            ->setEncryptionType($encryptionType)
            ->setHasPassword($hasPassword)
            ->setLastReported($lastReported)
            ->setWiFiNetworkName($wiFiNetworkName)
            ->setSignalStrength($signalStrength);
    }
    /**
     * Get EncryptionType value
     * @return string
     */
    public function getEncryptionType()
    {
        return $this->EncryptionType;
    }
    /**
     * Set EncryptionType value
     * @uses \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encryptionType
     * @return \CustomerManagement\StructType\WiFiNetworkInfo
     */
    public function setEncryptionType($encryptionType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\WiFiEncryptionTypeEnum::valueIsValid($encryptionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $encryptionType, implode(', ', \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::getValidValues())), __LINE__);
        }
        $this->EncryptionType = $encryptionType;
        return $this;
    }
    /**
     * Get HasPassword value
     * @return bool
     */
    public function getHasPassword()
    {
        return $this->HasPassword;
    }
    /**
     * Set HasPassword value
     * @param bool $hasPassword
     * @return \CustomerManagement\StructType\WiFiNetworkInfo
     */
    public function setHasPassword($hasPassword = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPassword) && !is_bool($hasPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasPassword)), __LINE__);
        }
        $this->HasPassword = $hasPassword;
        return $this;
    }
    /**
     * Get LastReported value
     * @return string
     */
    public function getLastReported()
    {
        return $this->LastReported;
    }
    /**
     * Set LastReported value
     * @param string $lastReported
     * @return \CustomerManagement\StructType\WiFiNetworkInfo
     */
    public function setLastReported($lastReported = null)
    {
        // validation for constraint: string
        if (!is_null($lastReported) && !is_string($lastReported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastReported)), __LINE__);
        }
        $this->LastReported = $lastReported;
        return $this;
    }
    /**
     * Get WiFiNetworkName value
     * @return string|null
     */
    public function getWiFiNetworkName()
    {
        return $this->WiFiNetworkName;
    }
    /**
     * Set WiFiNetworkName value
     * @param string $wiFiNetworkName
     * @return \CustomerManagement\StructType\WiFiNetworkInfo
     */
    public function setWiFiNetworkName($wiFiNetworkName = null)
    {
        // validation for constraint: string
        if (!is_null($wiFiNetworkName) && !is_string($wiFiNetworkName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wiFiNetworkName)), __LINE__);
        }
        $this->WiFiNetworkName = $wiFiNetworkName;
        return $this;
    }
    /**
     * Get SignalStrength value
     * @return string|null
     */
    public function getSignalStrength()
    {
        return $this->SignalStrength;
    }
    /**
     * Set SignalStrength value
     * @param string $signalStrength
     * @return \CustomerManagement\StructType\WiFiNetworkInfo
     */
    public function setSignalStrength($signalStrength = null)
    {
        // validation for constraint: string
        if (!is_null($signalStrength) && !is_string($signalStrength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signalStrength)), __LINE__);
        }
        $this->SignalStrength = $signalStrength;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\WiFiNetworkInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
