<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for SolarProviderEnum EnumType
 * @subpackage Enumerations
 */
class SolarProviderEnum
{
    /**
     * Constant for value 'SolarEdgeTest'
     * @return string 'SolarEdgeTest'
     */
    const VALUE_SOLAR_EDGE_TEST = 'SolarEdgeTest';
    /**
     * Constant for value 'Enphase'
     * @return string 'Enphase'
     */
    const VALUE_ENPHASE = 'Enphase';
    /**
     * Constant for value 'SolarEdgeProd'
     * @return string 'SolarEdgeProd'
     */
    const VALUE_SOLAR_EDGE_PROD = 'SolarEdgeProd';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SOLAR_EDGE_TEST
     * @uses self::VALUE_ENPHASE
     * @uses self::VALUE_SOLAR_EDGE_PROD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOLAR_EDGE_TEST,
            self::VALUE_ENPHASE,
            self::VALUE_SOLAR_EDGE_PROD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
