<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for EnergyProgramEnum EnumType
 * @subpackage Enumerations
 */
class EnergyProgramEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'CenterPointDemandResponse'
     * @return string 'CenterPointDemandResponse'
     */
    const VALUE_CENTER_POINT_DEMAND_RESPONSE = 'CenterPointDemandResponse';
    /**
     * Constant for value 'ERCOTDemandResponse'
     * @return string 'ERCOTDemandResponse'
     */
    const VALUE_ERCOTDEMAND_RESPONSE = 'ERCOTDemandResponse';
    /**
     * Constant for value 'SDGEReduceYourUse'
     * @return string 'SDGEReduceYourUse'
     */
    const VALUE_SDGEREDUCE_YOUR_USE = 'SDGEReduceYourUse';
    /**
     * Constant for value 'ERCOTWeatherResponse'
     * @return string 'ERCOTWeatherResponse'
     */
    const VALUE_ERCOTWEATHER_RESPONSE = 'ERCOTWeatherResponse';
    /**
     * Constant for value 'ADCTestingProgram'
     * @return string 'ADCTestingProgram'
     */
    const VALUE_ADCTESTING_PROGRAM = 'ADCTestingProgram';
    /**
     * Constant for value 'SCEDemandResponse'
     * @return string 'SCEDemandResponse'
     */
    const VALUE_SCEDEMAND_RESPONSE = 'SCEDemandResponse';
    /**
     * Constant for value 'AustinDemandResponse'
     * @return string 'AustinDemandResponse'
     */
    const VALUE_AUSTIN_DEMAND_RESPONSE = 'AustinDemandResponse';
    /**
     * Constant for value 'SDGE2013'
     * @return string 'SDGE2013'
     */
    const VALUE_SDGE_2013 = 'SDGE2013';
    /**
     * Constant for value 'Reliant'
     * @return string 'Reliant'
     */
    const VALUE_RELIANT = 'Reliant';
    /**
     * Constant for value 'PJM'
     * @return string 'PJM'
     */
    const VALUE_PJM = 'PJM';
    /**
     * Constant for value 'EHTestingProgram'
     * @return string 'EHTestingProgram'
     */
    const VALUE_EHTESTING_PROGRAM = 'EHTestingProgram';
    /**
     * Constant for value 'GetBackTexas'
     * @return string 'GetBackTexas'
     */
    const VALUE_GET_BACK_TEXAS = 'GetBackTexas';
    /**
     * Constant for value 'Constellation2014'
     * @return string 'Constellation2014'
     */
    const VALUE_CONSTELLATION_2014 = 'Constellation2014';
    /**
     * Constant for value 'GetBackSCE'
     * @return string 'GetBackSCE'
     */
    const VALUE_GET_BACK_SCE = 'GetBackSCE';
    /**
     * Constant for value 'ConEdDemandResponse'
     * @return string 'ConEdDemandResponse'
     */
    const VALUE_CON_ED_DEMAND_RESPONSE = 'ConEdDemandResponse';
    /**
     * Constant for value 'HydroOneDemandResponse'
     * @return string 'HydroOneDemandResponse'
     */
    const VALUE_HYDRO_ONE_DEMAND_RESPONSE = 'HydroOneDemandResponse';
    /**
     * Constant for value 'DegreesOfDifference'
     * @return string 'DegreesOfDifference'
     */
    const VALUE_DEGREES_OF_DIFFERENCE = 'DegreesOfDifference';
    /**
     * Constant for value 'OrangeAndRockland'
     * @return string 'OrangeAndRockland'
     */
    const VALUE_ORANGE_AND_ROCKLAND = 'OrangeAndRockland';
    /**
     * Constant for value 'ConnexusEnergy'
     * @return string 'ConnexusEnergy'
     */
    const VALUE_CONNEXUS_ENERGY = 'ConnexusEnergy';
    /**
     * Constant for value 'CPSEnergy'
     * @return string 'CPSEnergy'
     */
    const VALUE_CPSENERGY = 'CPSEnergy';
    /**
     * Constant for value 'SCEDRAM'
     * @return string 'SCEDRAM'
     */
    const VALUE_SCEDRAM = 'SCEDRAM';
    /**
     * Constant for value 'PGEDRAM'
     * @return string 'PGEDRAM'
     */
    const VALUE_PGEDRAM = 'PGEDRAM';
    /**
     * Constant for value 'SawneeEMC'
     * @return string 'SawneeEMC'
     */
    const VALUE_SAWNEE_EMC = 'SawneeEMC';
    /**
     * Constant for value 'PSEGLongIsland'
     * @return string 'PSEGLongIsland'
     */
    const VALUE_PSEGLONG_ISLAND = 'PSEGLongIsland';
    /**
     * Constant for value 'LGE'
     * @return string 'LGE'
     */
    const VALUE_LGE = 'LGE';
    /**
     * Constant for value 'KU'
     * @return string 'KU'
     */
    const VALUE_KU = 'KU';
    /**
     * Constant for value 'PGESmartSaversCA'
     * @return string 'PGESmartSaversCA'
     */
    const VALUE_PGESMART_SAVERS_CA = 'PGESmartSaversCA';
    /**
     * Constant for value 'NYSEG'
     * @return string 'NYSEG'
     */
    const VALUE_NYSEG = 'NYSEG';
    /**
     * Constant for value 'RGE'
     * @return string 'RGE'
     */
    const VALUE_RGE = 'RGE';
    /**
     * Constant for value 'APS'
     * @return string 'APS'
     */
    const VALUE_APS = 'APS';
    /**
     * Constant for value 'UnitedIlluminating'
     * @return string 'UnitedIlluminating'
     */
    const VALUE_UNITED_ILLUMINATING = 'UnitedIlluminating';
    /**
     * Constant for value 'ElPasoElectric'
     * @return string 'ElPasoElectric'
     */
    const VALUE_EL_PASO_ELECTRIC = 'ElPasoElectric';
    /**
     * Constant for value 'SRPTest'
     * @return string 'SRPTest'
     */
    const VALUE_SRPTEST = 'SRPTest';
    /**
     * Constant for value 'EnergyHubWidgetEnrollment'
     * @return string 'EnergyHubWidgetEnrollment'
     */
    const VALUE_ENERGY_HUB_WIDGET_ENROLLMENT = 'EnergyHubWidgetEnrollment';
    /**
     * Constant for value 'ConEdCapacity'
     * @return string 'ConEdCapacity'
     */
    const VALUE_CON_ED_CAPACITY = 'ConEdCapacity';
    /**
     * Constant for value 'LES'
     * @return string 'LES'
     */
    const VALUE_LES = 'LES';
    /**
     * Constant for value 'SRP'
     * @return string 'SRP'
     */
    const VALUE_SRP = 'SRP';
    /**
     * Constant for value 'AlarmTest'
     * @return string 'AlarmTest'
     */
    const VALUE_ALARM_TEST = 'AlarmTest';
    /**
     * Constant for value 'NationalGridNY'
     * @return string 'NationalGridNY'
     */
    const VALUE_NATIONAL_GRID_NY = 'NationalGridNY';
    /**
     * Constant for value 'NationalGridNE'
     * @return string 'NationalGridNE'
     */
    const VALUE_NATIONAL_GRID_NE = 'NationalGridNE';
    /**
     * Constant for value 'APSCoolRewards'
     * @return string 'APSCoolRewards'
     */
    const VALUE_APSCOOL_REWARDS = 'APSCoolRewards';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CENTER_POINT_DEMAND_RESPONSE
     * @uses self::VALUE_ERCOTDEMAND_RESPONSE
     * @uses self::VALUE_SDGEREDUCE_YOUR_USE
     * @uses self::VALUE_ERCOTWEATHER_RESPONSE
     * @uses self::VALUE_ADCTESTING_PROGRAM
     * @uses self::VALUE_SCEDEMAND_RESPONSE
     * @uses self::VALUE_AUSTIN_DEMAND_RESPONSE
     * @uses self::VALUE_SDGE_2013
     * @uses self::VALUE_RELIANT
     * @uses self::VALUE_PJM
     * @uses self::VALUE_EHTESTING_PROGRAM
     * @uses self::VALUE_GET_BACK_TEXAS
     * @uses self::VALUE_CONSTELLATION_2014
     * @uses self::VALUE_GET_BACK_SCE
     * @uses self::VALUE_CON_ED_DEMAND_RESPONSE
     * @uses self::VALUE_HYDRO_ONE_DEMAND_RESPONSE
     * @uses self::VALUE_DEGREES_OF_DIFFERENCE
     * @uses self::VALUE_ORANGE_AND_ROCKLAND
     * @uses self::VALUE_CONNEXUS_ENERGY
     * @uses self::VALUE_CPSENERGY
     * @uses self::VALUE_SCEDRAM
     * @uses self::VALUE_PGEDRAM
     * @uses self::VALUE_SAWNEE_EMC
     * @uses self::VALUE_PSEGLONG_ISLAND
     * @uses self::VALUE_LGE
     * @uses self::VALUE_KU
     * @uses self::VALUE_PGESMART_SAVERS_CA
     * @uses self::VALUE_NYSEG
     * @uses self::VALUE_RGE
     * @uses self::VALUE_APS
     * @uses self::VALUE_UNITED_ILLUMINATING
     * @uses self::VALUE_EL_PASO_ELECTRIC
     * @uses self::VALUE_SRPTEST
     * @uses self::VALUE_ENERGY_HUB_WIDGET_ENROLLMENT
     * @uses self::VALUE_CON_ED_CAPACITY
     * @uses self::VALUE_LES
     * @uses self::VALUE_SRP
     * @uses self::VALUE_ALARM_TEST
     * @uses self::VALUE_NATIONAL_GRID_NY
     * @uses self::VALUE_NATIONAL_GRID_NE
     * @uses self::VALUE_APSCOOL_REWARDS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_CENTER_POINT_DEMAND_RESPONSE,
            self::VALUE_ERCOTDEMAND_RESPONSE,
            self::VALUE_SDGEREDUCE_YOUR_USE,
            self::VALUE_ERCOTWEATHER_RESPONSE,
            self::VALUE_ADCTESTING_PROGRAM,
            self::VALUE_SCEDEMAND_RESPONSE,
            self::VALUE_AUSTIN_DEMAND_RESPONSE,
            self::VALUE_SDGE_2013,
            self::VALUE_RELIANT,
            self::VALUE_PJM,
            self::VALUE_EHTESTING_PROGRAM,
            self::VALUE_GET_BACK_TEXAS,
            self::VALUE_CONSTELLATION_2014,
            self::VALUE_GET_BACK_SCE,
            self::VALUE_CON_ED_DEMAND_RESPONSE,
            self::VALUE_HYDRO_ONE_DEMAND_RESPONSE,
            self::VALUE_DEGREES_OF_DIFFERENCE,
            self::VALUE_ORANGE_AND_ROCKLAND,
            self::VALUE_CONNEXUS_ENERGY,
            self::VALUE_CPSENERGY,
            self::VALUE_SCEDRAM,
            self::VALUE_PGEDRAM,
            self::VALUE_SAWNEE_EMC,
            self::VALUE_PSEGLONG_ISLAND,
            self::VALUE_LGE,
            self::VALUE_KU,
            self::VALUE_PGESMART_SAVERS_CA,
            self::VALUE_NYSEG,
            self::VALUE_RGE,
            self::VALUE_APS,
            self::VALUE_UNITED_ILLUMINATING,
            self::VALUE_EL_PASO_ELECTRIC,
            self::VALUE_SRPTEST,
            self::VALUE_ENERGY_HUB_WIDGET_ENROLLMENT,
            self::VALUE_CON_ED_CAPACITY,
            self::VALUE_LES,
            self::VALUE_SRP,
            self::VALUE_ALARM_TEST,
            self::VALUE_NATIONAL_GRID_NY,
            self::VALUE_NATIONAL_GRID_NE,
            self::VALUE_APSCOOL_REWARDS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
