<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddExistingLoginInput StructType
 * @subpackage Structs
 */
class AddExistingLoginInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The LoginId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginId;
    /**
     * Constructor method for AddExistingLoginInput
     * @uses AddExistingLoginInput::setCustomerId()
     * @uses AddExistingLoginInput::setLoginId()
     * @param int $customerId
     * @param int $loginId
     */
    public function __construct($customerId = null, $loginId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLoginId($loginId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddExistingLoginInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get LoginId value
     * @return int
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \CustomerManagement\StructType\AddExistingLoginInput
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !is_numeric($loginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\AddExistingLoginInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
