<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for RadioNetworkTypeEnum EnumType
 * @subpackage Enumerations
 */
class RadioNetworkTypeEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Broadband'
     * @return string 'Broadband'
     */
    const VALUE_BROADBAND = 'Broadband';
    /**
     * Constant for value 'GPRS'
     * @return string 'GPRS'
     */
    const VALUE_GPRS = 'GPRS';
    /**
     * Constant for value 'CDMA'
     * @return string 'CDMA'
     */
    const VALUE_CDMA = 'CDMA';
    /**
     * Constant for value 'HSPA_GPRS'
     * @return string 'HSPA_GPRS'
     */
    const VALUE_HSPA_GPRS = 'HSPA_GPRS';
    /**
     * Constant for value 'TwoWayPager'
     * @return string 'TwoWayPager'
     */
    const VALUE_TWO_WAY_PAGER = 'TwoWayPager';
    /**
     * Constant for value 'LTE_VZW'
     * @return string 'LTE_VZW'
     */
    const VALUE_LTE_VZW = 'LTE_VZW';
    /**
     * Constant for value 'CDMA_HSPA_LTE_COMBO'
     * @return string 'CDMA_HSPA_LTE_COMBO'
     */
    const VALUE_CDMA_HSPA_LTE_COMBO = 'CDMA_HSPA_LTE_COMBO';
    /**
     * Constant for value 'HSPA_LTE'
     * @return string 'HSPA_LTE'
     */
    const VALUE_HSPA_LTE = 'HSPA_LTE';
    /**
     * Constant for value 'LTE_CATM'
     * @return string 'LTE_CATM'
     */
    const VALUE_LTE_CATM = 'LTE_CATM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_BROADBAND
     * @uses self::VALUE_GPRS
     * @uses self::VALUE_CDMA
     * @uses self::VALUE_HSPA_GPRS
     * @uses self::VALUE_TWO_WAY_PAGER
     * @uses self::VALUE_LTE_VZW
     * @uses self::VALUE_CDMA_HSPA_LTE_COMBO
     * @uses self::VALUE_HSPA_LTE
     * @uses self::VALUE_LTE_CATM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_BROADBAND,
            self::VALUE_GPRS,
            self::VALUE_CDMA,
            self::VALUE_HSPA_GPRS,
            self::VALUE_TWO_WAY_PAGER,
            self::VALUE_LTE_VZW,
            self::VALUE_CDMA_HSPA_LTE_COMBO,
            self::VALUE_HSPA_LTE,
            self::VALUE_LTE_CATM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
