<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetPauseNotificationsForCustomer StructType
 * @subpackage Structs
 */
class SetPauseNotificationsForCustomer extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The timeUtc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $timeUtc;
    /**
     * Constructor method for SetPauseNotificationsForCustomer
     * @uses SetPauseNotificationsForCustomer::setCustomerId()
     * @uses SetPauseNotificationsForCustomer::setTimeUtc()
     * @param int $customerId
     * @param string $timeUtc
     */
    public function __construct($customerId = null, $timeUtc = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setTimeUtc($timeUtc);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetPauseNotificationsForCustomer
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get timeUtc value
     * @return string
     */
    public function getTimeUtc()
    {
        return $this->timeUtc;
    }
    /**
     * Set timeUtc value
     * @param string $timeUtc
     * @return \CustomerManagement\StructType\SetPauseNotificationsForCustomer
     */
    public function setTimeUtc($timeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($timeUtc) && !is_string($timeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeUtc)), __LINE__);
        }
        $this->timeUtc = $timeUtc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SetPauseNotificationsForCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
