<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DowngradeSecurityToSAVAccountInput StructType
 * @subpackage Structs
 */
class DowngradeSecurityToSAVAccountInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The NewPackageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NewPackageId;
    /**
     * The NewPackageTemplateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NewPackageTemplateId;
    /**
     * The AddOnFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public $AddOnFeatures;
    /**
     * Constructor method for DowngradeSecurityToSAVAccountInput
     * @uses DowngradeSecurityToSAVAccountInput::setCustomerId()
     * @uses DowngradeSecurityToSAVAccountInput::setNewPackageId()
     * @uses DowngradeSecurityToSAVAccountInput::setNewPackageTemplateId()
     * @uses DowngradeSecurityToSAVAccountInput::setAddOnFeatures()
     * @param int $customerId
     * @param int $newPackageId
     * @param int $newPackageTemplateId
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     */
    public function __construct($customerId = null, $newPackageId = null, $newPackageTemplateId = null, \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewPackageId($newPackageId)
            ->setNewPackageTemplateId($newPackageTemplateId)
            ->setAddOnFeatures($addOnFeatures);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get NewPackageId value
     * @return int
     */
    public function getNewPackageId()
    {
        return $this->NewPackageId;
    }
    /**
     * Set NewPackageId value
     * @param int $newPackageId
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public function setNewPackageId($newPackageId = null)
    {
        // validation for constraint: int
        if (!is_null($newPackageId) && !is_numeric($newPackageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newPackageId)), __LINE__);
        }
        $this->NewPackageId = $newPackageId;
        return $this;
    }
    /**
     * Get NewPackageTemplateId value
     * @return int
     */
    public function getNewPackageTemplateId()
    {
        return $this->NewPackageTemplateId;
    }
    /**
     * Set NewPackageTemplateId value
     * @param int $newPackageTemplateId
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public function setNewPackageTemplateId($newPackageTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($newPackageTemplateId) && !is_numeric($newPackageTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newPackageTemplateId)), __LINE__);
        }
        $this->NewPackageTemplateId = $newPackageTemplateId;
        return $this;
    }
    /**
     * Get AddOnFeatures value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum|null
     */
    public function getAddOnFeatures()
    {
        return $this->AddOnFeatures;
    }
    /**
     * Set AddOnFeatures value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public function setAddOnFeatures(\CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this->AddOnFeatures = $addOnFeatures;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\DowngradeSecurityToSAVAccountInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
