<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for SimStatusEnum EnumType
 * @subpackage Enumerations
 */
class SimStatusEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Suspended'
     * @return string 'Suspended'
     */
    const VALUE_SUSPENDED = 'Suspended';
    /**
     * Constant for value 'Inactive'
     * @return string 'Inactive'
     */
    const VALUE_INACTIVE = 'Inactive';
    /**
     * Constant for value 'PendingActivation'
     * @return string 'PendingActivation'
     */
    const VALUE_PENDING_ACTIVATION = 'PendingActivation';
    /**
     * Constant for value 'PendingPlanChange'
     * @return string 'PendingPlanChange'
     */
    const VALUE_PENDING_PLAN_CHANGE = 'PendingPlanChange';
    /**
     * Constant for value 'PendingResume'
     * @return string 'PendingResume'
     */
    const VALUE_PENDING_RESUME = 'PendingResume';
    /**
     * Constant for value 'PendingSuspend'
     * @return string 'PendingSuspend'
     */
    const VALUE_PENDING_SUSPEND = 'PendingSuspend';
    /**
     * Constant for value 'PendingIccidChange'
     * @return string 'PendingIccidChange'
     */
    const VALUE_PENDING_ICCID_CHANGE = 'PendingIccidChange';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_SUSPENDED
     * @uses self::VALUE_INACTIVE
     * @uses self::VALUE_PENDING_ACTIVATION
     * @uses self::VALUE_PENDING_PLAN_CHANGE
     * @uses self::VALUE_PENDING_RESUME
     * @uses self::VALUE_PENDING_SUSPEND
     * @uses self::VALUE_PENDING_ICCID_CHANGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_ERROR,
            self::VALUE_ACTIVE,
            self::VALUE_SUSPENDED,
            self::VALUE_INACTIVE,
            self::VALUE_PENDING_ACTIVATION,
            self::VALUE_PENDING_PLAN_CHANGE,
            self::VALUE_PENDING_RESUME,
            self::VALUE_PENDING_SUSPEND,
            self::VALUE_PENDING_ICCID_CHANGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
