<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TroubleConditionsRestoresItem StructType
 * @subpackage Structs
 */
class TroubleConditionsRestoresItem extends AbstractStructBase
{
    /**
     * The TroubleConditionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TroubleConditionType;
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Zone;
    /**
     * The Partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Partition;
    /**
     * The IsRestored
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRestored;
    /**
     * The TroubleConditionStartUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TroubleConditionStartUtc;
    /**
     * The TroubleConditionEndUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TroubleConditionEndUtc;
    /**
     * The UniqueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\UniqueIdentifier
     */
    public $UniqueId;
    /**
     * The Trouble
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trouble;
    /**
     * Constructor method for TroubleConditionsRestoresItem
     * @uses TroubleConditionsRestoresItem::setTroubleConditionType()
     * @uses TroubleConditionsRestoresItem::setZone()
     * @uses TroubleConditionsRestoresItem::setPartition()
     * @uses TroubleConditionsRestoresItem::setIsRestored()
     * @uses TroubleConditionsRestoresItem::setTroubleConditionStartUtc()
     * @uses TroubleConditionsRestoresItem::setTroubleConditionEndUtc()
     * @uses TroubleConditionsRestoresItem::setUniqueId()
     * @uses TroubleConditionsRestoresItem::setTrouble()
     * @param string $troubleConditionType
     * @param int $zone
     * @param int $partition
     * @param bool $isRestored
     * @param string $troubleConditionStartUtc
     * @param string $troubleConditionEndUtc
     * @param \CustomerManagement\StructType\UniqueIdentifier $uniqueId
     * @param string $trouble
     */
    public function __construct($troubleConditionType = null, $zone = null, $partition = null, $isRestored = null, $troubleConditionStartUtc = null, $troubleConditionEndUtc = null, \CustomerManagement\StructType\UniqueIdentifier $uniqueId = null, $trouble = null)
    {
        $this
            ->setTroubleConditionType($troubleConditionType)
            ->setZone($zone)
            ->setPartition($partition)
            ->setIsRestored($isRestored)
            ->setTroubleConditionStartUtc($troubleConditionStartUtc)
            ->setTroubleConditionEndUtc($troubleConditionEndUtc)
            ->setUniqueId($uniqueId)
            ->setTrouble($trouble);
    }
    /**
     * Get TroubleConditionType value
     * @return string
     */
    public function getTroubleConditionType()
    {
        return $this->TroubleConditionType;
    }
    /**
     * Set TroubleConditionType value
     * @uses \CustomerManagement\EnumType\TroubleConditionTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\TroubleConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $troubleConditionType
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTroubleConditionType($troubleConditionType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\TroubleConditionTypeEnum::valueIsValid($troubleConditionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\TroubleConditionTypeEnum', is_array($troubleConditionType) ? implode(', ', $troubleConditionType) : var_export($troubleConditionType, true), implode(', ', \CustomerManagement\EnumType\TroubleConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->TroubleConditionType = $troubleConditionType;
        return $this;
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Partition value
     * @return int
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @param int $partition
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setPartition($partition = null)
    {
        // validation for constraint: int
        if (!is_null($partition) && !(is_int($partition) || ctype_digit($partition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partition, true), gettype($partition)), __LINE__);
        }
        $this->Partition = $partition;
        return $this;
    }
    /**
     * Get IsRestored value
     * @return bool
     */
    public function getIsRestored()
    {
        return $this->IsRestored;
    }
    /**
     * Set IsRestored value
     * @param bool $isRestored
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setIsRestored($isRestored = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRestored) && !is_bool($isRestored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRestored, true), gettype($isRestored)), __LINE__);
        }
        $this->IsRestored = $isRestored;
        return $this;
    }
    /**
     * Get TroubleConditionStartUtc value
     * @return string
     */
    public function getTroubleConditionStartUtc()
    {
        return $this->TroubleConditionStartUtc;
    }
    /**
     * Set TroubleConditionStartUtc value
     * @param string $troubleConditionStartUtc
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTroubleConditionStartUtc($troubleConditionStartUtc = null)
    {
        // validation for constraint: string
        if (!is_null($troubleConditionStartUtc) && !is_string($troubleConditionStartUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($troubleConditionStartUtc, true), gettype($troubleConditionStartUtc)), __LINE__);
        }
        $this->TroubleConditionStartUtc = $troubleConditionStartUtc;
        return $this;
    }
    /**
     * Get TroubleConditionEndUtc value
     * @return string
     */
    public function getTroubleConditionEndUtc()
    {
        return $this->TroubleConditionEndUtc;
    }
    /**
     * Set TroubleConditionEndUtc value
     * @param string $troubleConditionEndUtc
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTroubleConditionEndUtc($troubleConditionEndUtc = null)
    {
        // validation for constraint: string
        if (!is_null($troubleConditionEndUtc) && !is_string($troubleConditionEndUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($troubleConditionEndUtc, true), gettype($troubleConditionEndUtc)), __LINE__);
        }
        $this->TroubleConditionEndUtc = $troubleConditionEndUtc;
        return $this;
    }
    /**
     * Get UniqueId value
     * @return \CustomerManagement\StructType\UniqueIdentifier|null
     */
    public function getUniqueId()
    {
        return $this->UniqueId;
    }
    /**
     * Set UniqueId value
     * @param \CustomerManagement\StructType\UniqueIdentifier $uniqueId
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setUniqueId(\CustomerManagement\StructType\UniqueIdentifier $uniqueId = null)
    {
        $this->UniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get Trouble value
     * @return string|null
     */
    public function getTrouble()
    {
        return $this->Trouble;
    }
    /**
     * Set Trouble value
     * @param string $trouble
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTrouble($trouble = null)
    {
        // validation for constraint: string
        if (!is_null($trouble) && !is_string($trouble)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trouble, true), gettype($trouble)), __LINE__);
        }
        $this->Trouble = $trouble;
        return $this;
    }
}
