<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCustomerLoginInput StructType
 * @subpackage Structs
 */
class AddCustomerLoginInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SendEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendEmail;
    /**
     * The Culture
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Culture;
    /**
     * The NewLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewLogin;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The LoginNameAtAuthenticationProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginNameAtAuthenticationProvider;
    /**
     * The Roles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $Roles;
    /**
     * The ProfileFirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileFirstName;
    /**
     * The ProfileLastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileLastName;
    /**
     * Constructor method for AddCustomerLoginInput
     * @uses AddCustomerLoginInput::setCustomerId()
     * @uses AddCustomerLoginInput::setSendEmail()
     * @uses AddCustomerLoginInput::setCulture()
     * @uses AddCustomerLoginInput::setNewLogin()
     * @uses AddCustomerLoginInput::setPassword()
     * @uses AddCustomerLoginInput::setEmail()
     * @uses AddCustomerLoginInput::setLoginNameAtAuthenticationProvider()
     * @uses AddCustomerLoginInput::setRoles()
     * @uses AddCustomerLoginInput::setProfileFirstName()
     * @uses AddCustomerLoginInput::setProfileLastName()
     * @param int $customerId
     * @param bool $sendEmail
     * @param string $culture
     * @param string $newLogin
     * @param string $password
     * @param string $email
     * @param string $loginNameAtAuthenticationProvider
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     * @param string $profileFirstName
     * @param string $profileLastName
     */
    public function __construct($customerId = null, $sendEmail = null, $culture = null, $newLogin = null, $password = null, $email = null, $loginNameAtAuthenticationProvider = null, \CustomerManagement\ArrayType\ArrayOfInt $roles = null, $profileFirstName = null, $profileLastName = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSendEmail($sendEmail)
            ->setCulture($culture)
            ->setNewLogin($newLogin)
            ->setPassword($password)
            ->setEmail($email)
            ->setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider)
            ->setRoles($roles)
            ->setProfileFirstName($profileFirstName)
            ->setProfileLastName($profileLastName);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SendEmail value
     * @return bool
     */
    public function getSendEmail()
    {
        return $this->SendEmail;
    }
    /**
     * Set SendEmail value
     * @param bool $sendEmail
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmail, true), gettype($sendEmail)), __LINE__);
        }
        $this->SendEmail = $sendEmail;
        return $this;
    }
    /**
     * Get Culture value
     * @return string
     */
    public function getCulture()
    {
        return $this->Culture;
    }
    /**
     * Set Culture value
     * @uses \CustomerManagement\EnumType\CultureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CultureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $culture
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setCulture($culture = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CultureEnum::valueIsValid($culture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CultureEnum', is_array($culture) ? implode(', ', $culture) : var_export($culture, true), implode(', ', \CustomerManagement\EnumType\CultureEnum::getValidValues())), __LINE__);
        }
        $this->Culture = $culture;
        return $this;
    }
    /**
     * Get NewLogin value
     * @return string|null
     */
    public function getNewLogin()
    {
        return $this->NewLogin;
    }
    /**
     * Set NewLogin value
     * @param string $newLogin
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setNewLogin($newLogin = null)
    {
        // validation for constraint: string
        if (!is_null($newLogin) && !is_string($newLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newLogin, true), gettype($newLogin)), __LINE__);
        }
        $this->NewLogin = $newLogin;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get LoginNameAtAuthenticationProvider value
     * @return string|null
     */
    public function getLoginNameAtAuthenticationProvider()
    {
        return $this->LoginNameAtAuthenticationProvider;
    }
    /**
     * Set LoginNameAtAuthenticationProvider value
     * @param string $loginNameAtAuthenticationProvider
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider = null)
    {
        // validation for constraint: string
        if (!is_null($loginNameAtAuthenticationProvider) && !is_string($loginNameAtAuthenticationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginNameAtAuthenticationProvider, true), gettype($loginNameAtAuthenticationProvider)), __LINE__);
        }
        $this->LoginNameAtAuthenticationProvider = $loginNameAtAuthenticationProvider;
        return $this;
    }
    /**
     * Get Roles value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getRoles()
    {
        return $this->Roles;
    }
    /**
     * Set Roles value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setRoles(\CustomerManagement\ArrayType\ArrayOfInt $roles = null)
    {
        $this->Roles = $roles;
        return $this;
    }
    /**
     * Get ProfileFirstName value
     * @return string|null
     */
    public function getProfileFirstName()
    {
        return $this->ProfileFirstName;
    }
    /**
     * Set ProfileFirstName value
     * @param string $profileFirstName
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setProfileFirstName($profileFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($profileFirstName) && !is_string($profileFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileFirstName, true), gettype($profileFirstName)), __LINE__);
        }
        $this->ProfileFirstName = $profileFirstName;
        return $this;
    }
    /**
     * Get ProfileLastName value
     * @return string|null
     */
    public function getProfileLastName()
    {
        return $this->ProfileLastName;
    }
    /**
     * Set ProfileLastName value
     * @param string $profileLastName
     * @return \CustomerManagement\StructType\AddCustomerLoginInput
     */
    public function setProfileLastName($profileLastName = null)
    {
        // validation for constraint: string
        if (!is_null($profileLastName) && !is_string($profileLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileLastName, true), gettype($profileLastName)), __LINE__);
        }
        $this->ProfileLastName = $profileLastName;
        return $this;
    }
}
