<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PowerSourceTypeEnum EnumType
 * @subpackage Enumerations
 */
class PowerSourceTypeEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'AcPower'
     * @return string 'AcPower'
     */
    const VALUE_AC_POWER = 'AcPower';
    /**
     * Constant for value 'ExternalBattery'
     * @return string 'ExternalBattery'
     */
    const VALUE_EXTERNAL_BATTERY = 'ExternalBattery';
    /**
     * Constant for value 'InternalBattery'
     * @return string 'InternalBattery'
     */
    const VALUE_INTERNAL_BATTERY = 'InternalBattery';
    /**
     * Constant for value 'Solar'
     * @return string 'Solar'
     */
    const VALUE_SOLAR = 'Solar';
    /**
     * Constant for value 'Usb'
     * @return string 'Usb'
     */
    const VALUE_USB = 'Usb';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return allowed values
     * @uses self::VALUE_AC_POWER
     * @uses self::VALUE_EXTERNAL_BATTERY
     * @uses self::VALUE_INTERNAL_BATTERY
     * @uses self::VALUE_SOLAR
     * @uses self::VALUE_USB
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AC_POWER,
            self::VALUE_EXTERNAL_BATTERY,
            self::VALUE_INTERNAL_BATTERY,
            self::VALUE_SOLAR,
            self::VALUE_USB,
            self::VALUE_UNKNOWN,
        );
    }
}
