<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetAddOnQuantity StructType
 * @subpackage Structs
 */
class SetAddOnQuantity extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The addOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $addOn;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * Constructor method for SetAddOnQuantity
     * @uses SetAddOnQuantity::setCustomerId()
     * @uses SetAddOnQuantity::setAddOn()
     * @uses SetAddOnQuantity::setQuantity()
     * @param int $customerId
     * @param string $addOn
     * @param int $quantity
     */
    public function __construct($customerId = null, $addOn = null, $quantity = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setAddOn($addOn)
            ->setQuantity($quantity);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetAddOnQuantity
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get addOn value
     * @return string
     */
    public function getAddOn()
    {
        return $this->addOn;
    }
    /**
     * Set addOn value
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addOn
     * @return \CustomerManagement\StructType\SetAddOnQuantity
     */
    public function setAddOn($addOn = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid($addOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\AddOnFeatureEnum', is_array($addOn) ? implode(', ', $addOn) : var_export($addOn, true), implode(', ', \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues())), __LINE__);
        }
        $this->addOn = $addOn;
        return $this;
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \CustomerManagement\StructType\SetAddOnQuantity
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
}
