<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSystemCheckResultsInput StructType
 * @subpackage Structs
 */
class GetSystemCheckResultsInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The CallerVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallerVersion;
    /**
     * Constructor method for GetSystemCheckResultsInput
     * @uses GetSystemCheckResultsInput::setCustomerId()
     * @uses GetSystemCheckResultsInput::setCallerVersion()
     * @param int $customerId
     * @param int $callerVersion
     */
    public function __construct($customerId = null, $callerVersion = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCallerVersion($callerVersion);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\GetSystemCheckResultsInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get CallerVersion value
     * @return int
     */
    public function getCallerVersion()
    {
        return $this->CallerVersion;
    }
    /**
     * Set CallerVersion value
     * @param int $callerVersion
     * @return \CustomerManagement\StructType\GetSystemCheckResultsInput
     */
    public function setCallerVersion($callerVersion = null)
    {
        // validation for constraint: int
        if (!is_null($callerVersion) && !is_numeric($callerVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($callerVersion)), __LINE__);
        }
        $this->CallerVersion = $callerVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetSystemCheckResultsInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
