<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueIdentifier StructType
 * @subpackage Structs
 */
class UniqueIdentifier extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The StartDateUtcTicks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StartDateUtcTicks;
    /**
     * Constructor method for UniqueIdentifier
     * @uses UniqueIdentifier::setDeviceId()
     * @uses UniqueIdentifier::setType()
     * @uses UniqueIdentifier::setStartDateUtcTicks()
     * @param int $deviceId
     * @param string $type
     * @param int $startDateUtcTicks
     */
    public function __construct($deviceId = null, $type = null, $startDateUtcTicks = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setType($type)
            ->setStartDateUtcTicks($startDateUtcTicks);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\UniqueIdentifier
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \CustomerManagement\EnumType\TroubleConditionTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\TroubleConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \CustomerManagement\StructType\UniqueIdentifier
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\TroubleConditionTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\TroubleConditionTypeEnum', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \CustomerManagement\EnumType\TroubleConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get StartDateUtcTicks value
     * @return int
     */
    public function getStartDateUtcTicks()
    {
        return $this->StartDateUtcTicks;
    }
    /**
     * Set StartDateUtcTicks value
     * @param int $startDateUtcTicks
     * @return \CustomerManagement\StructType\UniqueIdentifier
     */
    public function setStartDateUtcTicks($startDateUtcTicks = null)
    {
        // validation for constraint: int
        if (!is_null($startDateUtcTicks) && !(is_int($startDateUtcTicks) || ctype_digit($startDateUtcTicks))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startDateUtcTicks, true), gettype($startDateUtcTicks)), __LINE__);
        }
        $this->StartDateUtcTicks = $startDateUtcTicks;
        return $this;
    }
}
