<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelSettingInfo StructType
 * @subpackage Structs
 */
class PanelSettingInfo extends AbstractStructBase
{
    /**
     * The PanelSettingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelSettingId;
    /**
     * The MinValueLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinValueLength;
    /**
     * The MaxValueLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxValueLength;
    /**
     * The MinValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinValue;
    /**
     * The MaxValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxValue;
    /**
     * The SettingType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SettingType;
    /**
     * The IsEditable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEditable;
    /**
     * The PanelSettingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PanelSettingName;
    /**
     * The PanelSettingDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PanelSettingDesc;
    /**
     * The RegexForValidation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegexForValidation;
    /**
     * The PossibleValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfPanelSettingSelection
     */
    public $PossibleValues;
    /**
     * Constructor method for PanelSettingInfo
     * @uses PanelSettingInfo::setPanelSettingId()
     * @uses PanelSettingInfo::setMinValueLength()
     * @uses PanelSettingInfo::setMaxValueLength()
     * @uses PanelSettingInfo::setMinValue()
     * @uses PanelSettingInfo::setMaxValue()
     * @uses PanelSettingInfo::setSettingType()
     * @uses PanelSettingInfo::setIsEditable()
     * @uses PanelSettingInfo::setPanelSettingName()
     * @uses PanelSettingInfo::setPanelSettingDesc()
     * @uses PanelSettingInfo::setRegexForValidation()
     * @uses PanelSettingInfo::setPossibleValues()
     * @param int $panelSettingId
     * @param int $minValueLength
     * @param int $maxValueLength
     * @param int $minValue
     * @param int $maxValue
     * @param string $settingType
     * @param bool $isEditable
     * @param string $panelSettingName
     * @param string $panelSettingDesc
     * @param string $regexForValidation
     * @param \CustomerManagement\ArrayType\ArrayOfPanelSettingSelection $possibleValues
     */
    public function __construct($panelSettingId = null, $minValueLength = null, $maxValueLength = null, $minValue = null, $maxValue = null, $settingType = null, $isEditable = null, $panelSettingName = null, $panelSettingDesc = null, $regexForValidation = null, \CustomerManagement\ArrayType\ArrayOfPanelSettingSelection $possibleValues = null)
    {
        $this
            ->setPanelSettingId($panelSettingId)
            ->setMinValueLength($minValueLength)
            ->setMaxValueLength($maxValueLength)
            ->setMinValue($minValue)
            ->setMaxValue($maxValue)
            ->setSettingType($settingType)
            ->setIsEditable($isEditable)
            ->setPanelSettingName($panelSettingName)
            ->setPanelSettingDesc($panelSettingDesc)
            ->setRegexForValidation($regexForValidation)
            ->setPossibleValues($possibleValues);
    }
    /**
     * Get PanelSettingId value
     * @return int
     */
    public function getPanelSettingId()
    {
        return $this->PanelSettingId;
    }
    /**
     * Set PanelSettingId value
     * @param int $panelSettingId
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setPanelSettingId($panelSettingId = null)
    {
        // validation for constraint: int
        if (!is_null($panelSettingId) && !(is_int($panelSettingId) || ctype_digit($panelSettingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelSettingId, true), gettype($panelSettingId)), __LINE__);
        }
        $this->PanelSettingId = $panelSettingId;
        return $this;
    }
    /**
     * Get MinValueLength value
     * @return int
     */
    public function getMinValueLength()
    {
        return $this->MinValueLength;
    }
    /**
     * Set MinValueLength value
     * @param int $minValueLength
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setMinValueLength($minValueLength = null)
    {
        // validation for constraint: int
        if (!is_null($minValueLength) && !(is_int($minValueLength) || ctype_digit($minValueLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minValueLength, true), gettype($minValueLength)), __LINE__);
        }
        $this->MinValueLength = $minValueLength;
        return $this;
    }
    /**
     * Get MaxValueLength value
     * @return int
     */
    public function getMaxValueLength()
    {
        return $this->MaxValueLength;
    }
    /**
     * Set MaxValueLength value
     * @param int $maxValueLength
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setMaxValueLength($maxValueLength = null)
    {
        // validation for constraint: int
        if (!is_null($maxValueLength) && !(is_int($maxValueLength) || ctype_digit($maxValueLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxValueLength, true), gettype($maxValueLength)), __LINE__);
        }
        $this->MaxValueLength = $maxValueLength;
        return $this;
    }
    /**
     * Get MinValue value
     * @return int
     */
    public function getMinValue()
    {
        return $this->MinValue;
    }
    /**
     * Set MinValue value
     * @param int $minValue
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setMinValue($minValue = null)
    {
        // validation for constraint: int
        if (!is_null($minValue) && !(is_int($minValue) || ctype_digit($minValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minValue, true), gettype($minValue)), __LINE__);
        }
        $this->MinValue = $minValue;
        return $this;
    }
    /**
     * Get MaxValue value
     * @return int
     */
    public function getMaxValue()
    {
        return $this->MaxValue;
    }
    /**
     * Set MaxValue value
     * @param int $maxValue
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setMaxValue($maxValue = null)
    {
        // validation for constraint: int
        if (!is_null($maxValue) && !(is_int($maxValue) || ctype_digit($maxValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxValue, true), gettype($maxValue)), __LINE__);
        }
        $this->MaxValue = $maxValue;
        return $this;
    }
    /**
     * Get SettingType value
     * @return string
     */
    public function getSettingType()
    {
        return $this->SettingType;
    }
    /**
     * Set SettingType value
     * @uses \CustomerManagement\EnumType\PanelSettingTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelSettingTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $settingType
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setSettingType($settingType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelSettingTypeEnum::valueIsValid($settingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelSettingTypeEnum', is_array($settingType) ? implode(', ', $settingType) : var_export($settingType, true), implode(', ', \CustomerManagement\EnumType\PanelSettingTypeEnum::getValidValues())), __LINE__);
        }
        $this->SettingType = $settingType;
        return $this;
    }
    /**
     * Get IsEditable value
     * @return bool
     */
    public function getIsEditable()
    {
        return $this->IsEditable;
    }
    /**
     * Set IsEditable value
     * @param bool $isEditable
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setIsEditable($isEditable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditable) && !is_bool($isEditable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEditable, true), gettype($isEditable)), __LINE__);
        }
        $this->IsEditable = $isEditable;
        return $this;
    }
    /**
     * Get PanelSettingName value
     * @return string|null
     */
    public function getPanelSettingName()
    {
        return $this->PanelSettingName;
    }
    /**
     * Set PanelSettingName value
     * @param string $panelSettingName
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setPanelSettingName($panelSettingName = null)
    {
        // validation for constraint: string
        if (!is_null($panelSettingName) && !is_string($panelSettingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($panelSettingName, true), gettype($panelSettingName)), __LINE__);
        }
        $this->PanelSettingName = $panelSettingName;
        return $this;
    }
    /**
     * Get PanelSettingDesc value
     * @return string|null
     */
    public function getPanelSettingDesc()
    {
        return $this->PanelSettingDesc;
    }
    /**
     * Set PanelSettingDesc value
     * @param string $panelSettingDesc
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setPanelSettingDesc($panelSettingDesc = null)
    {
        // validation for constraint: string
        if (!is_null($panelSettingDesc) && !is_string($panelSettingDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($panelSettingDesc, true), gettype($panelSettingDesc)), __LINE__);
        }
        $this->PanelSettingDesc = $panelSettingDesc;
        return $this;
    }
    /**
     * Get RegexForValidation value
     * @return string|null
     */
    public function getRegexForValidation()
    {
        return $this->RegexForValidation;
    }
    /**
     * Set RegexForValidation value
     * @param string $regexForValidation
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setRegexForValidation($regexForValidation = null)
    {
        // validation for constraint: string
        if (!is_null($regexForValidation) && !is_string($regexForValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regexForValidation, true), gettype($regexForValidation)), __LINE__);
        }
        $this->RegexForValidation = $regexForValidation;
        return $this;
    }
    /**
     * Get PossibleValues value
     * @return \CustomerManagement\ArrayType\ArrayOfPanelSettingSelection|null
     */
    public function getPossibleValues()
    {
        return $this->PossibleValues;
    }
    /**
     * Set PossibleValues value
     * @param \CustomerManagement\ArrayType\ArrayOfPanelSettingSelection $possibleValues
     * @return \CustomerManagement\StructType\PanelSettingInfo
     */
    public function setPossibleValues(\CustomerManagement\ArrayType\ArrayOfPanelSettingSelection $possibleValues = null)
    {
        $this->PossibleValues = $possibleValues;
        return $this;
    }
}
